/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;

public class GraphNode<NS, E extends GraphEdge> {
    protected NS semantic;
    protected Collection<E> outgoingEdges = new ArrayList();
    protected Collection<E> incomingEdges = new ArrayList();

    public GraphNode(NS semantic) {
        this.semantic = semantic;
    }

    public NS getSemantic() {
        return this.semantic;
    }

    public Collection<E> getOutgoingEdges() {
        return Collections.unmodifiableCollection(this.outgoingEdges);
    }

    public Collection<E> getIncomingEdges() {
        return Collections.unmodifiableCollection(this.incomingEdges);
    }

    public Collection<E> getConnectedEdges() {
        return Streams.concat((Stream[])new Stream[]{this.incomingEdges.stream(), this.outgoingEdges.stream()}).collect(Collectors.toList());
    }

    public String toString() {
        return "n(" + EObjectLabelProviderHelper.getText(this.semantic) + ")";
    }
}

