/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class TarjanAlgorithm {
    private int V;
    private int preCount;
    private int[] low;
    private boolean[] visited;
    private Set<Integer>[] graph;
    private List<List<Integer>> sccComp;
    private Stack<Integer> stack;

    public List<List<Integer>> getSCComponents(Set<Integer>[] graph) {
        this.V = graph.length;
        this.graph = graph;
        this.low = new int[this.V];
        this.visited = new boolean[this.V];
        this.stack = new Stack();
        this.sccComp = new ArrayList<List<Integer>>();
        int v = 0;
        while (v < this.V) {
            if (!this.visited[v]) {
                this.dfs(v);
            }
            ++v;
        }
        return this.sccComp;
    }

    public void dfs(int v) {
        int w;
        ++this.preCount;
        this.visited[v] = true;
        this.stack.push(v);
        int min = this.low[v];
        for (int w2 : this.graph[v]) {
            if (!this.visited[w2]) {
                this.dfs(w2);
            }
            if (this.low[w2] >= min) continue;
            min = this.low[w2];
        }
        if (min < this.low[v]) {
            this.low[v] = min;
            return;
        }
        ArrayList<Integer> component = new ArrayList<Integer>();
        do {
            w = this.stack.pop();
            component.add(w);
            this.low[w] = this.V;
        } while (w != v);
        this.sccComp.add(component);
    }
}

