/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.detachment.propertyvalues.ui.page;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.detachment.propertyvalue.Activator;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;

public class PropertyValueHelper {
    public static Collection<IScrutinize> getScrutinizers(ModelScrutinyRegistry analysis, String id) {
        try {
            ModelScrutinyRegistry.RegistryElement regElt = analysis.getRegistryElement(id);
            return regElt.getFinders();
        }
        catch (ModelScrutinyException e) {
            Status status = new Status(4, "org.polarsys.capella.model.detachment.propertyvalue", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return Collections.emptySet();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean lookupSuperHierarchy(Object element, Class<?> ... clazzes) {
        if (!PropertyValueHelper.isPropertyValue(element)) return false;
        EObject root = EcoreUtil.getRootContainer((EObject)((EObject)element));
        EObject eContainer = ((EObject)element).eContainer();
        if (root == null || eContainer == null || root.equals(eContainer)) return false;
        Class<?>[] interfaces = eContainer.getClass().getInterfaces();
        boolean isRightClass = PropertyValueHelper.isRightType(interfaces, clazzes);
        if (isRightClass) return isRightClass;
        PropertyValueHelper.lookupSuperHierarchy(eContainer, clazzes);
        return false;
    }

    public static boolean isChildOfPropertyValue(Object elt) {
        return PropertyValueHelper.isPropertyValue(elt) && PropertyValueHelper.isPropertyValue(((EObject)elt).eContainer());
    }

    private static boolean isPropertyValue(Object elt) {
        return elt instanceof EObject && ((EObject)elt instanceof EnumerationPropertyLiteral || (EObject)elt instanceof EnumerationPropertyType || (EObject)elt instanceof PropertyValuePkg || (EObject)elt instanceof PropertyValueGroup || (EObject)elt instanceof AbstractPropertyValue);
    }

    private static boolean isRightType(Class<?>[] interfaces, Class<?> ... clazzes) {
        if (interfaces != null && interfaces.length != 0) {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                Class<?>[] classArray2 = clazzes;
                int n3 = clazzes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> c1 = classArray2[n4];
                    if (c1.equals(c)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean lookupOwnedPropertyValues(Object element) {
        if (element instanceof EnumerationPropertyLiteral) {
            EnumerationPropertyLiteral literal = (EnumerationPropertyLiteral)element;
            if (!literal.getOwnedPropertyValues().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)literal.getOwnedEnumerationPropertyTypes());
            elt.addAll((Collection<Object>)literal.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValues(elt);
        }
        if (element instanceof EnumerationPropertyType) {
            EnumerationPropertyType type = (EnumerationPropertyType)element;
            if (!type.getOwnedPropertyValues().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)type.getOwnedEnumerationPropertyTypes());
            elt.addAll((Collection<Object>)type.getOwnedLiterals());
            elt.addAll((Collection<Object>)type.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValues(elt);
        }
        if (element instanceof PropertyValuePkg) {
            PropertyValuePkg pkg = (PropertyValuePkg)element;
            if (!pkg.getOwnedPropertyValues().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValuePkgs());
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValueGroups());
            elt.addAll((Collection<Object>)pkg.getOwnedEnumerationPropertyTypes());
            return PropertyValueHelper.lookupOwnedPropertyValues(elt);
        }
        if (element instanceof PropertyValueGroup) {
            PropertyValueGroup grp = (PropertyValueGroup)element;
            if (!grp.getOwnedPropertyValues().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)grp.getOwnedPropertyValueGroups());
            elt.addAll((Collection<Object>)grp.getOwnedEnumerationPropertyTypes());
            return PropertyValueHelper.lookupOwnedPropertyValues(elt);
        }
        return false;
    }

    private static boolean lookupOwnedPropertyValues(Collection<Object> elt) {
        boolean result = false;
        for (Object object : elt) {
            result = PropertyValueHelper.lookupOwnedPropertyValues(object);
            if (!result) continue;
            return result;
        }
        return false;
    }

    public static boolean lookupOwnedPropertyValuesGroup(Object element) {
        if (element instanceof EnumerationPropertyLiteral) {
            EnumerationPropertyLiteral literal = (EnumerationPropertyLiteral)element;
            if (!literal.getOwnedPropertyValueGroups().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)literal.getOwnedEnumerationPropertyTypes());
            elt.addAll((Collection<Object>)literal.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValuesGroup(elt);
        }
        if (element instanceof EnumerationPropertyType) {
            EnumerationPropertyType type = (EnumerationPropertyType)element;
            if (!type.getOwnedPropertyValueGroups().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)type.getOwnedEnumerationPropertyTypes());
            elt.addAll((Collection<Object>)type.getOwnedLiterals());
            elt.addAll((Collection<Object>)type.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValuesGroup(elt);
        }
        if (element instanceof PropertyValuePkg) {
            PropertyValuePkg pkg = (PropertyValuePkg)element;
            if (!pkg.getOwnedPropertyValueGroups().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValuePkgs());
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValueGroups());
            elt.addAll((Collection<Object>)pkg.getOwnedEnumerationPropertyTypes());
            return PropertyValueHelper.lookupOwnedPropertyValuesGroup(elt);
        }
        if (element instanceof AbstractPropertyValue) {
            AbstractPropertyValue pv = (AbstractPropertyValue)element;
            if (!pv.getOwnedPropertyValueGroups().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)pv.getOwnedPropertyValues());
            elt.addAll((Collection<Object>)pv.getOwnedEnumerationPropertyTypes());
            return PropertyValueHelper.lookupOwnedPropertyValuesGroup(elt);
        }
        return false;
    }

    private static boolean lookupOwnedPropertyValuesGroup(Collection<Object> elt) {
        boolean result = false;
        for (Object object : elt) {
            result = PropertyValueHelper.lookupOwnedPropertyValuesGroup(object);
            if (!result) continue;
            return result;
        }
        return false;
    }

    public static boolean lookupOwnedPropertyValuesEnum(Object element) {
        if (element instanceof EnumerationPropertyLiteral) {
            EnumerationPropertyLiteral literal = (EnumerationPropertyLiteral)element;
            if (!literal.getOwnedEnumerationPropertyTypes().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)literal.getOwnedPropertyValueGroups());
            elt.addAll((Collection<Object>)literal.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValuesEnum(elt);
        }
        if (element instanceof PropertyValueGroup) {
            PropertyValueGroup grp = (PropertyValueGroup)element;
            if (!grp.getOwnedEnumerationPropertyTypes().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)grp.getOwnedPropertyValues());
            elt.addAll((Collection<Object>)grp.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValuesEnum(elt);
        }
        if (element instanceof PropertyValuePkg) {
            PropertyValuePkg pkg = (PropertyValuePkg)element;
            if (!pkg.getOwnedEnumerationPropertyTypes().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValuePkgs());
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValueGroups());
            elt.addAll((Collection<Object>)pkg.getOwnedPropertyValues());
            return PropertyValueHelper.lookupOwnedPropertyValuesEnum(elt);
        }
        if (element instanceof AbstractPropertyValue) {
            AbstractPropertyValue pv = (AbstractPropertyValue)element;
            if (!pv.getOwnedEnumerationPropertyTypes().isEmpty()) {
                return true;
            }
            HashSet<Object> elt = new HashSet<Object>();
            elt.addAll((Collection<Object>)pv.getOwnedPropertyValues());
            elt.addAll((Collection<Object>)pv.getOwnedPropertyValueGroups());
            return PropertyValueHelper.lookupOwnedPropertyValuesEnum(elt);
        }
        return false;
    }

    private static boolean lookupOwnedPropertyValuesEnum(Collection<Object> elt) {
        boolean result = false;
        for (Object object : elt) {
            result = PropertyValueHelper.lookupOwnedPropertyValuesEnum(object);
            if (!result) continue;
            return result;
        }
        return false;
    }
}

