/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_PhysicalLink_AllocatedComponentExchanges
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        return this.getAvailableElements(capellaElement);
    }

    public List<Object> getAvailableElements(CapellaElement element) {
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)element);
        if (arch == null) {
            return Collections.emptyList();
        }
        if (!(element instanceof PhysicalLink)) {
            return Collections.emptyList();
        }
        PhysicalLink link = (PhysicalLink)element;
        Component sourceComponent = PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
        Component targetComponent = PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
        if (sourceComponent == null || targetComponent == null) {
            return Collections.emptyList();
        }
        Set<ComponentExchange> availableElements = this.getAvailableExchanges(sourceComponent, targetComponent);
        Iterator<ComponentExchange> it = availableElements.iterator();
        while (it.hasNext()) {
            ComponentExchange connection = it.next();
            EList incomingTraces = connection.getIncomingTraces();
            for (AbstractTrace abstractTrace : incomingTraces) {
                if (!(abstractTrace instanceof ComponentExchangeAllocation) || ((ComponentExchangeAllocation)abstractTrace).getComponentExchangeAllocator() == link) continue;
                it.remove();
            }
        }
        return List.copyOf(availableElements);
    }

    private Set<ComponentExchange> getAvailableExchanges(Component sourceComponent, Component targetComponent) {
        HashSet<ComponentExchange> availableElements = new HashSet<ComponentExchange>();
        Collection sourceComponents = ComponentExt.getAllSubUsedComponents((Component)sourceComponent);
        sourceComponents.add(sourceComponent);
        Collection targetComponents = ComponentExt.getAllSubUsedComponents((Component)targetComponent);
        targetComponents.add(targetComponent);
        List<Component> sourceDeployedElements = this.getDeployedElements(sourceComponents);
        List<Component> targetDeployedElements = this.getDeployedElements(targetComponents);
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(sourceDeployedElements, targetDeployedElements));
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(targetDeployedElements, sourceDeployedElements));
        return availableElements;
    }

    private List<Component> getDeployedElements(Collection<Component> components) {
        HashSet<Component> deployedComponents = new HashSet<Component>();
        for (Component component : components) {
            if (component instanceof SystemComponent) {
                deployedComponents.add(component);
                continue;
            }
            if (component instanceof LogicalComponent) {
                deployedComponents.addAll(LogicalComponentExt.getAllSubComponents((LogicalComponent)((LogicalComponent)component)));
                continue;
            }
            if (!(component instanceof PhysicalComponent)) continue;
            deployedComponents.add(component);
            for (AbstractTypedElement abstractTypedElement : component.getAbstractTypedElements()) {
                if (!(abstractTypedElement instanceof Part)) continue;
                Part typedPart = (Part)abstractTypedElement;
                Stream.concat(PartExt.getSubUsedParts((Part)typedPart).stream(), PartExt.getAllDeployableElements((Part)typedPart).stream()).filter(Part.class::isInstance).map(p -> PartExt.getComponentOfPart((Part)((Part)p))).filter(Objects::nonNull).forEachOrdered(deployedComponents::add);
            }
        }
        return List.copyOf(deployedComponents);
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof PhysicalLink) {
            PhysicalLink ele = (PhysicalLink)element;
            EList ownedComponentExchangeAllocation = ele.getOwnedComponentExchangeAllocations();
            for (ComponentExchangeAllocation ownedComponentExchangeAll : ownedComponentExchangeAllocation) {
                ComponentExchange componentExchangeAllocated = ownedComponentExchangeAll.getComponentExchangeAllocated();
                if (componentExchangeAllocated == null) continue;
                currentElements.add((CapellaElement)componentExchangeAllocated);
            }
        }
        return currentElements;
    }
}

