/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;

public class PhysicalLinksCreator
extends DefaultExchangesCreator {
    private Part part = null;

    public PhysicalLinksCreator(Component component, Part part) {
        super(component);
        this.part = part;
    }

    @Override
    public void createExchanges() {
        boolean physicalLinkCreated;
        if (this.isValidBound(this._component) && !(physicalLinkCreated = this.createPhysicalLinksFromCExchanges(this._component))) {
            String message = "No physical link has been created.";
            EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName());
            logger.info((Object)eMessage);
        }
    }

    @Override
    protected boolean isValidCreation(AbstractEventOperation fe, Component component, Component allocating) {
        return this.isValidBound(component) && this.isValidBound(allocating);
    }

    protected boolean createPhysicalLinksFromCExchanges(Component container) {
        boolean physicalLinkCreated = false;
        if (container instanceof PhysicalComponent) {
            EList deployments = this.part.getDeploymentLinks();
            for (AbstractDeploymentLink deployment : deployments) {
                if (!(deployment instanceof PartDeploymentLink)) continue;
                PartDeploymentLink deploymentLink = (PartDeploymentLink)deployment;
                DeployableElement deployedElement = deploymentLink.getDeployedElement();
                if (deployedElement instanceof Part) {
                    Type containedPC = ((Part)deployedElement).getType();
                    if (!(containedPC instanceof PhysicalComponent)) continue;
                    physicalLinkCreated |= this.createPhysicalLinksFromCExchanges(container, (Component)((PhysicalComponent)containedPC));
                    continue;
                }
                if (!(deployedElement instanceof PhysicalComponent)) continue;
                physicalLinkCreated |= this.createPhysicalLinksFromCExchanges(container, (Component)((PhysicalComponent)deployedElement));
            }
        }
        if (!this.isContainedByALogicalNonActorComponent(container)) {
            physicalLinkCreated |= this.createPLsFromCEDiffLevels(container);
            physicalLinkCreated |= this.createPLsFromCESameLevel(container);
        }
        return physicalLinkCreated;
    }

    protected boolean createPLsFromCEDiffLevels(Component container) {
        List subComponents = ComponentExt.getSubDefinedComponents((Component)container);
        if (!subComponents.isEmpty()) {
            return subComponents.stream().filter(ComponentExt::isActor).map(actor -> this.createPhysicalLinksFromCExchanges(container, (Component)actor)).reduce(Boolean.FALSE, Boolean::logicalOr);
        }
        return false;
    }

    protected boolean createPLsFromCESameLevel(Component container) {
        if (ComponentExt.isActor((Component)container) || !this.isNodeComponent(container)) {
            return this.createPhysicalLinksFromCExchanges(container, container);
        }
        return false;
    }

    protected boolean createPhysicalLinksFromCExchanges(Component sourceContainer, Component sourceContained) {
        boolean physicalLinkCreated = false;
        if (this.isValidBound(sourceContained)) {
            for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)sourceContained)) {
                for (ComponentExchange componentExchange : port.getComponentExchanges()) {
                    physicalLinkCreated |= this.processComponentExchange(sourceContainer, sourceContained, port, componentExchange) != null;
                }
            }
        }
        return physicalLinkCreated;
    }

    private boolean isContainedByALogicalNonActorComponent(Component component) {
        EObject container = component.eContainer();
        if (container instanceof LogicalComponent) {
            return !ComponentExt.isActor((EObject)container) || this.isContainedByALogicalNonActorComponent((Component)container);
        }
        return false;
    }

    private PhysicalLink processComponentExchange(Component sourceContainer, Component sourceContained, ComponentPort port, ComponentExchange componentExchange) {
        if (componentExchange.getKind() == ComponentExchangeKind.DELEGATION || componentExchange.getKind() == ComponentExchangeKind.UNSET || this.doesNodeAlreadyHasAPhysicalLinkForComponentExchange(sourceContainer, componentExchange)) {
            String message = "Component exchange " + componentExchange.getName() + " already has a physical link or the kind is not suitable.";
            EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), (Object)componentExchange);
            logger.error((Object)eMessage);
            return null;
        }
        Component targetContained = this.findTheTargetComponent(componentExchange, port);
        Component target = this.computePhysicalLinkBound(targetContained);
        Component source = this.computePhysicalLinkBound(sourceContained);
        if (!this.isValidPhysicalLinkBound(source)) {
            String message = "Component " + source.getName() + " cannot host a Physical Link.";
            EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), (Object)source);
            logger.error((Object)eMessage);
            return null;
        }
        if (!this.isValidPhysicalLinkBound(target)) {
            String message = "Component " + target.getName() + " cannot host a Physical Link.";
            EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), (Object)target);
            logger.error((Object)eMessage);
            return null;
        }
        return this.doCreatePhysicalLink(componentExchange, source, target, port);
    }

    private boolean isBehaviourComponent(Component component) {
        return component instanceof PhysicalComponent && ((PhysicalComponent)component).getNature() == PhysicalComponentNature.BEHAVIOR;
    }

    private boolean isNodeComponent(Component component) {
        return component instanceof PhysicalComponent && ((PhysicalComponent)component).getNature() == PhysicalComponentNature.NODE;
    }

    private Component findTheTargetComponent(ComponentExchange componentExchange, ComponentPort port) {
        InformationsExchanger target = FunctionalExt.getOtherBound((ExchangeSpecification)componentExchange, (InformationsExchanger)port);
        if (!(target instanceof ComponentPort)) {
            return null;
        }
        EObject targetContained = target.eContainer();
        return (Component)targetContained;
    }

    private boolean isValidPhysicalLinkBound(Component bound) {
        Component targetContained = bound;
        if (!(targetContained instanceof Component) || !this.isValidBound(targetContained)) {
            return false;
        }
        if ((targetContained instanceof LogicalComponent || targetContained instanceof SystemComponent) && !ComponentExt.isActor((Component)targetContained) && !this.isSystemOrLogicalSystem(targetContained)) {
            return false;
        }
        if (this.isBehaviourComponent(targetContained)) {
            return false;
        }
        return !ComponentExt.isActor((Component)targetContained) || !this.isContainedByALogicalNonActorComponent(targetContained);
    }

    private boolean isSystemOrLogicalSystem(Component component) {
        if (component instanceof PhysicalComponent || component instanceof Entity) {
            return false;
        }
        BlockArchitecture architecture = ComponentExt.getRootBlockArchitecture((ModelElement)component);
        return architecture.getSystem().equals(component);
    }

    private Component computePhysicalLinkBound(Component componentExchangeBound) {
        if (componentExchangeBound == null) {
            return null;
        }
        for (Part partition : componentExchangeBound.getRepresentingParts()) {
            for (DeploymentTarget deploying : (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)partition)) {
                Part deployingPart;
                if (!(deploying instanceof Part) || !((deployingPart = (Part)deploying).getAbstractType() instanceof PhysicalComponent) || this.isBehaviourComponent((Component)((PhysicalComponent)deployingPart.getAbstractType()))) continue;
                return (PhysicalComponent)deployingPart.getAbstractType();
            }
        }
        if (ComponentExt.isActor((Component)componentExchangeBound) && componentExchangeBound.eContainer() instanceof Component && !this.isBehaviourComponent((Component)componentExchangeBound.eContainer())) {
            return (Component)componentExchangeBound.eContainer();
        }
        return componentExchangeBound;
    }

    private PhysicalLink doCreatePhysicalLink(ComponentExchange componentExchange, Component exchangeOutput, Component exchangeInput, ComponentPort sourcePort) {
        if (componentExchange.getSource().equals(sourcePort)) {
            return this.doCreatePhysicalLink(componentExchange, exchangeOutput, exchangeInput);
        }
        return this.doCreatePhysicalLink(componentExchange, exchangeInput, exchangeOutput);
    }

    protected PhysicalLink doCreatePhysicalLink(ComponentExchange componentExchange, Component exchangeOutput, Component exchangeInput) {
        if (exchangeOutput == exchangeInput) {
            return null;
        }
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(componentExchange.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getSource().getLabel());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getTarget().getLabel());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput.getOwnedFeatures().add((Object)inP);
        exchangeOutput.getOwnedFeatures().add((Object)outP);
        CapellaElementExt.creationService((EObject)inP);
        CapellaElementExt.creationService((EObject)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        CapellaElementExt.creationService((EObject)physicalLink);
        ComponentExchangeAllocation cea = FaFactory.eINSTANCE.createComponentExchangeAllocation();
        cea.setSourceElement((TraceableElement)physicalLink);
        cea.setTargetElement((TraceableElement)componentExchange);
        physicalLink.getOwnedComponentExchangeAllocations().add((Object)cea);
        CapellaElementExt.creationService((EObject)cea);
        InformationsExchanger target = componentExchange.getTarget();
        this.createComponentPortAllocation(target, inP);
        InformationsExchanger source = componentExchange.getSource();
        this.createComponentPortAllocation(source, outP);
        exchangeInput.getOwnedPhysicalLinks().add((Object)physicalLink);
        exchangeOutput.getOwnedPhysicalLinks().add((Object)physicalLink);
        String message = "The Physical link " + physicalLink.getName() + " has been succefully created between the source " + exchangeOutput.getLabel() + " and the target " + exchangeInput.getLabel();
        EmbeddedMessage eMessage = new EmbeddedMessage(message, logger.getName(), Arrays.asList(physicalLink, exchangeOutput, exchangeInput));
        logger.info((Object)eMessage);
        return physicalLink;
    }

    private ComponentPortAllocation createComponentPortAllocation(InformationsExchanger informationExchange, PhysicalPort physicalPort) {
        ComponentPortAllocation allocation = FaFactory.eINSTANCE.createComponentPortAllocation();
        allocation.setSourceElement((TraceableElement)physicalPort);
        allocation.setTargetElement((TraceableElement)informationExchange);
        physicalPort.getOwnedComponentPortAllocations().add((Object)allocation);
        CapellaElementExt.creationService((EObject)allocation);
        return allocation;
    }

    protected boolean doesNodeAlreadyHasAPhysicalLinkForComponentExchange(Component physicalComponent, ComponentExchange componentExchange) {
        boolean result = false;
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)componentExchange);
        SiriusCrossReferenceAdapter crossReferencer = editingDomain.getCrossReferencer();
        Collection inverseReferences = crossReferencer.getInverseReferences((EObject)componentExchange, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            if (!(setting.getEObject() instanceof ComponentExchangeAllocation)) continue;
            result = true;
            break;
        }
        return result;
    }
}

