/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPattern;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternData;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.CorepatternsPackage;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.OclPatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter.CustomOperation;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter.OperationSignature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.CollectionUtil;

public class PatternEnvironmentFactory
extends EcoreEnvironmentFactory {
    protected final Map<OperationSignature, CustomOperation> _additionalOperations = new HashMap<OperationSignature, CustomOperation>();

    protected void addCustomOperations(EcoreEnvironment env_p) {
        this.addEObjectOperations(env_p);
        this.addPatternOperations(env_p);
    }

    protected void addEObjectOperations(EcoreEnvironment env_p) {
        EClassifier everyElement = (EClassifier)env_p.getOCLStandardLibrary().getOclAny();
        OCLStandardLibrary lib = env_p.getOCLStandardLibrary();
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclOwner", everyElement, false){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                return ((EObject)source_p).eContainer();
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclOwners", everyElement, true){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                EObject current = ((EObject)source_p).eContainer();
                while (current != null) {
                    result.add(current);
                    current = current.eContainer();
                }
                return result;
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclChildren", everyElement, true){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                return ((EObject)source_p).eContents();
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclAllChildren", everyElement, true){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                TreeIterator it = ((EObject)source_p).eAllContents();
                while (it.hasNext()) {
                    result.add((EObject)it.next());
                }
                return result;
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclIsLeaf", (EClassifier)lib.getBoolean(), false){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                boolean result = ((EObject)source_p).eContents().isEmpty();
                return result;
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclIsRoot", (EClassifier)lib.getBoolean(), false){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                boolean result = ((EObject)source_p).eContainer() == null;
                return result;
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "oclTypeName", (EClassifier)lib.getString(), false){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                EClass type = ((EObject)source_p).eClass();
                EPackage epackage = type.getEPackage();
                return String.valueOf(epackage.getName()) + "::" + type.getName();
            }
        });
    }

    protected void addPatternOperations(EcoreEnvironment env_p) {
        EClassifier everyElement = (EClassifier)env_p.getOCLStandardLibrary().getOclAny();
        EClass instanceType = CorepatternsPackage.eINSTANCE.getAbstractPatternInstance();
        EClass patternType = CorepatternsPackage.eINSTANCE.getAbstractPattern();
        final Object INVALID = env_p.getOCLStandardLibrary().getInvalid();
        this.registerCustomOperation(env_p, new CustomOperation(everyElement, "patternInstances", (EClassifier)instanceType, true){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                BasicEList result = new BasicEList();
                EObject element = (EObject)source_p;
                IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor(element);
                if (support != null) {
                    List instances = support.getRelatedInstances(element);
                    for (IPatternInstance instance : instances) {
                        if (!(instance instanceof AbstractPatternInstance)) continue;
                        result.add((Object)((AbstractPatternInstance)instance));
                    }
                }
                return result;
            }
        });
        this.registerCustomOperation(env_p, new CustomOperation((EClassifier)instanceType, "pattern", (EClassifier)patternType, false){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                Object result = INVALID;
                AbstractPatternInstance instance = (AbstractPatternInstance)source_p;
                IPattern pattern = instance.getPattern();
                if (pattern instanceof AbstractPattern) {
                    result = pattern;
                }
                return result;
            }
        });
        Variable parameter = ExpressionsFactory.eINSTANCE.createVariable();
        parameter.setName("element");
        parameter.setType((Object)everyElement);
        List<Variable> parameters = Collections.singletonList(parameter);
        this.registerCustomOperation(env_p, new CustomOperation((EClassifier)instanceType, "patternElement", everyElement, false, parameters){

            @Override
            public Object executeOn(Object source_p, List<Object> args_p) {
                Object first;
                Object result = INVALID;
                if (source_p instanceof AbstractPatternInstance && args_p != null && !args_p.isEmpty() && (first = args_p.get(0)) instanceof EObject) {
                    EObject patternElement;
                    EObject element = (EObject)first;
                    AbstractPatternInstance instance = (AbstractPatternInstance)source_p;
                    AbstractPatternData data = instance.getPatternData();
                    if (data instanceof TemplatePatternData && (patternElement = ((TemplatePatternData)data).getCounterpart(element, false)) != null) {
                        result = patternElement;
                    }
                }
                return result;
            }
        });
    }

    public EcoreEnvironment createEnvironment() {
        EcoreEnvironment result = (EcoreEnvironment)super.createEnvironment();
        this.addCustomOperations(result);
        return result;
    }

    public ExtendedEcoreEvaluationEnvironment createEvaluationEnvironment() {
        return new ExtendedEcoreEvaluationEnvironment();
    }

    public ExtendedEcoreEvaluationEnvironment createEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent) {
        return new ExtendedEcoreEvaluationEnvironment(parent);
    }

    protected void registerCustomOperation(EcoreEnvironment env_p, CustomOperation customOperation_p) {
        customOperation_p.defineIn(env_p);
        this._additionalOperations.put(customOperation_p.getSignature(), customOperation_p);
    }

    private class ExtendedEcoreEvaluationEnvironment
    extends EcoreEvaluationEnvironment {
        public ExtendedEcoreEvaluationEnvironment() {
        }

        public ExtendedEcoreEvaluationEnvironment(EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> parent_p) {
            super(parent_p);
        }

        public Object callOperation(EOperation operation_p, int opcode_p, Object source_p, Object[] args_p) throws IllegalArgumentException {
            Object result = null;
            OperationSignature signature = new OperationSignature(operation_p);
            CustomOperation customOperation = PatternEnvironmentFactory.this._additionalOperations.get(signature);
            if (customOperation != null) {
                result = customOperation.executeOn(source_p, Arrays.asList(args_p));
            }
            result = result != null ? this.coerceValue((ETypedElement)operation_p, result, false) : super.callOperation(operation_p, opcode_p, source_p, args_p);
            return result;
        }

        protected Object coerceValue(ETypedElement element_p, Object value_p, boolean copy_p) {
            CollectionKind kind = this.getCollectionKind2(element_p);
            if (kind != null) {
                if (value_p instanceof Collection) {
                    return copy_p ? CollectionUtil.createNewCollection((CollectionKind)kind, (Collection)((Collection)value_p)) : value_p;
                }
                Collection result = CollectionUtil.createNewCollection((CollectionKind)kind);
                result.add(value_p);
                return result;
            }
            if (value_p instanceof Collection) {
                Collection collection = (Collection)value_p;
                return collection.isEmpty() ? null : collection.iterator().next();
            }
            return value_p;
        }

        private CollectionKind getCollectionKind2(ETypedElement element) {
            CollectionKind result = null;
            OCLStandardLibrary<EClassifier> library = OclPatternsPlugin.getDefault().getInterpreter().getStandardLibrary();
            if (element.isMany()) {
                result = CollectionKind.getKind((boolean)element.isOrdered(), (boolean)element.isUnique());
            } else if (element.getEType() == library.getOrderedSet()) {
                result = CollectionKind.ORDERED_SET_LITERAL;
            } else if (element.getEType() == library.getSequence()) {
                result = CollectionKind.SEQUENCE_LITERAL;
            } else if (element.getEType() == library.getSet()) {
                result = CollectionKind.SET_LITERAL;
            } else if (element.getEType() == library.getBag()) {
                result = CollectionKind.BAG_LITERAL;
            } else if (element.getEType() == library.getCollection()) {
                result = CollectionKind.COLLECTION_LITERAL;
            }
            return result;
        }
    }
}

