/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.actions.extensions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.accelerators.SelectOrCreateFunctionalExchangeDialog;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;

public class SelectOrCreateFunctionalExchangeWizard
extends AbstractExternalJavaAction {
    protected FunctionalChainServices fcsInstance = FunctionalChainServices.getFunctionalChainServices();
    protected DEdge seqLinkEdge;
    protected List<DNode> availableSourceFCIFViews;
    protected List<DNode> availableTargetFCIFViews;
    protected Set<AbstractFunction> availableSourceFunctions;
    protected Set<AbstractFunction> availableTargetFunctions;
    protected Shell currentShell;

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EObject context = (EObject)parameters.get("context");
        this.seqLinkEdge = (DEdge)context;
        this.currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String messageDialogTitle = "Accelerator Information";
        this.availableSourceFCIFViews = this.fcsInstance.findFlatClosestFCIFunctionViewsAsSource(this.seqLinkEdge, true);
        if (this.availableSourceFCIFViews.isEmpty()) {
            MessageDialog.openInformation((Shell)this.currentShell, (String)messageDialogTitle, (String)"There is not any Functional Chain Involvement Function as source for the selected sequence link or they are all in collapsed container.");
            return;
        }
        this.availableTargetFCIFViews = this.fcsInstance.findFlatClosestFCIFunctionViewsAsTarget(this.seqLinkEdge, true);
        if (this.availableTargetFCIFViews.isEmpty()) {
            MessageDialog.openInformation((Shell)this.currentShell, (String)messageDialogTitle, (String)"There is not any Functional Chain Involvement Function as target for the selected sequence link or they are all in collapsed container.");
            return;
        }
        this.availableSourceFunctions = this.fcsInstance.getFunctionsFromFCIFDNodes(this.availableSourceFCIFViews);
        this.availableTargetFunctions = this.fcsInstance.getFunctionsFromFCIFDNodes(this.availableTargetFCIFViews);
        HashSet<FunctionalExchange> availableFEs = new HashSet<FunctionalExchange>();
        for (AbstractFunction sourceFunction : this.availableSourceFunctions) {
            for (AbstractFunction targetFunction : this.availableTargetFunctions) {
                List commonEdges = FunctionExt.getOutGoingExchange((AbstractFunction)sourceFunction);
                commonEdges.retainAll(FunctionExt.getIncomingExchange((AbstractFunction)targetFunction));
                availableFEs.addAll(commonEdges);
            }
        }
        this.selectOrCreateFunctionalExchangeData(availableFEs);
    }

    protected void selectOrCreateFunctionalExchangeData(Set<FunctionalExchange> availableFEs) {
        SelectOrCreateFunctionalExchangeDialog dialog = new SelectOrCreateFunctionalExchangeDialog(this.currentShell, availableFEs, this.availableSourceFunctions, this.availableTargetFunctions);
        int returnCode = dialog.open();
        SelectOrCreateFunctionalExchangeDialog.NewFEData newFEData = null;
        AbstractFunction feSource = null;
        AbstractFunction feTarget = null;
        FunctionalExchange involvedFE = null;
        if (returnCode == 5) {
            newFEData = dialog.getCreation();
            feSource = newFEData.getSource();
            feTarget = newFEData.getTarget();
        }
        if (returnCode == 10) {
            involvedFE = dialog.getSelection().stream().findFirst().orElse(null);
            feSource = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)involvedFE);
            feTarget = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)involvedFE);
        }
        this.createFunctionalExchange(newFEData, feSource, feTarget, involvedFE);
    }

    protected void createFunctionalExchange(SelectOrCreateFunctionalExchangeDialog.NewFEData newFEData, AbstractFunction feSource, AbstractFunction feTarget, FunctionalExchange involvedFE) {
        String messageDialogTitle = "Accelerator Information";
        List<DNode> possibleSourceFCIFNodes = this.fcsInstance.getFCIFViewsInvolvingFunction(this.availableSourceFCIFViews, feSource);
        List<DNode> possibleTargetFCIFNodes = this.fcsInstance.getFCIFViewsInvolvingFunction(this.availableTargetFCIFViews, feTarget);
        int sourceSize = possibleSourceFCIFNodes.size();
        int targetSize = possibleTargetFCIFNodes.size();
        if (sourceSize > 1 || targetSize > 1) {
            MessageDialog.openInformation((Shell)this.currentShell, (String)messageDialogTitle, (String)"Impossible to create Functional Chain Involvement Link due to ambiguity of source and target");
        }
        if (sourceSize == 1 && targetSize == 1) {
            if (newFEData != null) {
                involvedFE = FunctionalExchangeExt.createFunctionalExchange((ActivityNode)feSource, (ActivityNode)feTarget);
                involvedFE.setName(newFEData.getName());
                ((AbstractFunction)feSource.eContainer()).getOwnedFunctionalExchanges().add((Object)involvedFE);
            }
            DNode sourceFCIFNode = possibleSourceFCIFNodes.get(0);
            DNode targetFCIFNode = possibleTargetFCIFNodes.get(0);
            this.fcsInstance.createFCILink(sourceFCIFNode, targetFCIFNode, involvedFE, this.seqLinkEdge);
        }
    }
}

