/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.FoldingFilter;
import org.eclipse.sirius.diagram.FoldingPointFilter;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;

public class BreakdownRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    @Override
    public void beforeRefresh(DDiagram dDiagram) {
        super.beforeRefresh(dDiagram);
        this.repairCollapsedElements(dDiagram);
    }

    protected boolean isDirectlyCollapsed(DDiagramElement element) {
        for (GraphicalFilter filter : element.getGraphicalFilters()) {
            if (!(filter instanceof FoldingFilter)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollapsedParent(DDiagramElement parent) {
        if (!((Boolean)ModelCache.getCache(this::isDirectlyCollapsed, (Object)parent)).booleanValue() && parent instanceof EdgeTarget) {
            EdgeTarget edgeTarget = (EdgeTarget)parent;
            for (DEdge edge : edgeTarget.getIncomingEdges()) {
                if (!(edge.getSourceNode() instanceof DDiagramElement) || !((Boolean)ModelCache.getCache(this::isDirectlyCollapsed, (Object)((DDiagramElement)edge.getSourceNode()))).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void unfold(DDiagramElement element) {
        ArrayList<GraphicalFilter> filters = new ArrayList<GraphicalFilter>();
        for (GraphicalFilter filter : element.getGraphicalFilters()) {
            if (filter instanceof FoldingFilter) {
                filters.add(filter);
            }
            if (!(filter instanceof FoldingPointFilter)) continue;
            filters.add(filter);
        }
        for (GraphicalFilter filter : filters) {
            element.getGraphicalFilters().remove((Object)filter);
        }
    }

    protected void repairCollapsedElements(DDiagram diagram) {
        Map<EObject, DragAndDropTarget> elements = DiagramServices.getDiagramServices().getMapOfDiagramNodes(diagram);
        HashSet<DDiagramElement> toUnfold = new HashSet<DDiagramElement>();
        HashSet<DDiagramElement> toFold = new HashSet<DDiagramElement>();
        block0: for (DDiagramElement element : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            if (!(element instanceof AbstractDNode)) continue;
            boolean elementIsCollapsed = (Boolean)ModelCache.getCache(this::isDirectlyCollapsed, (Object)element);
            LinkedList parents = new LinkedList();
            LinkedList<EObject> visitedObjects = new LinkedList<EObject>();
            EObject target = element.getTarget();
            if (target == null) continue;
            parents.addAll((Collection)ModelCache.getCache(this::getContainers, (Object)target));
            while (!parents.isEmpty()) {
                EObject targetParent = (EObject)parents.removeFirst();
                if (visitedObjects.contains(targetParent)) continue;
                visitedObjects.add(targetParent);
                DragAndDropTarget viewParent = elements.get(targetParent);
                if (viewParent instanceof DDiagramElement) {
                    boolean parentIsDirectlyCollapsed = (Boolean)ModelCache.getCache(this::isDirectlyCollapsed, (Object)((DDiagramElement)viewParent));
                    boolean parentIsUndirectlyCollapsed = (Boolean)ModelCache.getCache(this::isCollapsedParent, (Object)((DDiagramElement)viewParent));
                    if (elementIsCollapsed && !parentIsDirectlyCollapsed) {
                        toUnfold.add(element);
                        continue block0;
                    }
                    if (!elementIsCollapsed && parentIsDirectlyCollapsed) {
                        toFold.add(element);
                        continue block0;
                    }
                    if (elementIsCollapsed && parentIsDirectlyCollapsed && !parentIsUndirectlyCollapsed) {
                        toUnfold.add(element);
                        continue block0;
                    }
                    if (parentIsDirectlyCollapsed) {
                        continue block0;
                    }
                } else if (viewParent == null) {
                    toUnfold.add(element);
                }
                if (targetParent == null) continue;
                parents.addAll((Collection)ModelCache.getCache(this::getContainers, (Object)targetParent));
            }
        }
        for (DDiagramElement element : toUnfold) {
            List<EObject> parents = this.getBreakdownParents(element);
            if (parents.size() <= 1) continue;
            boolean contains = false;
            for (EObject semanticParent : (Collection)ModelCache.getCache(this::getContainers, (Object)element.getTarget())) {
                if (!parents.contains(semanticParent)) continue;
                contains = true;
            }
            if (contains) continue;
            this.unfold(element);
        }
    }

    private Collection<EObject> getContainers(EObject e) {
        ArrayList<EObject> parents = new ArrayList<EObject>();
        if (e instanceof Component) {
            parents.addAll(CsServices.getService().getContainersOfParts((Component)e));
        } else {
            parents.add(e.eContainer());
        }
        return parents;
    }

    private List<EObject> getBreakdownParents(DDiagramElement element) {
        LinkedList<DDiagramElement> parents = new LinkedList<DDiagramElement>();
        LinkedList<DDiagramElement> visitedElements = new LinkedList<DDiagramElement>();
        LinkedList<EObject> visitedObjects = new LinkedList<EObject>();
        parents.add(element);
        while (!parents.isEmpty()) {
            DDiagramElement parent = (DDiagramElement)parents.removeFirst();
            if (visitedElements.contains(parent)) continue;
            visitedElements.add(parent);
            visitedObjects.add(parent.getTarget());
            if (parent != element || !(parent instanceof EdgeTarget)) continue;
            for (DEdge edge : ((EdgeTarget)parent).getOutgoingEdges()) {
                if (!(edge.getTargetNode() instanceof DDiagramElement)) continue;
                parents.addLast((DDiagramElement)edge.getTargetNode());
            }
        }
        return visitedObjects;
    }
}

