/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.titleblock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.sirius.analysis.TitleBlockServices;

public class TitleBlockUpdaterListener
extends ResourceSetListenerImpl {
    private final Session siriuSession;

    TitleBlockUpdaterListener(Session session) {
        this.siriuSession = session;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        List notifications = event.getNotifications();
        Iterator notifIterator = notifications.iterator();
        final LinkedHashMap<DRepresentationDescriptor, List> titleBlockCells = new LinkedHashMap<DRepresentationDescriptor, List>();
        while (notifIterator.hasNext()) {
            DRepresentation representation;
            Notification notification = (Notification)notifIterator.next();
            Object notifier = notification.getNotifier();
            if (!ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR.isInstance(notifier) || !ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__CHANGE_ID.equals(notification.getFeature()) || !((representation = ((DRepresentationDescriptor)notifier).getRepresentation()) instanceof DDiagram)) continue;
            List<DAnnotation> diagramTitleBlocks = TitleBlockServices.getService().getTitleBlocksInDiagram((DDiagram)representation);
            for (DAnnotation titleBlock : diagramTitleBlocks) {
                for (DAnnotation line : TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlock)) {
                    for (DAnnotation cell : TitleBlockHelper.getTitleBlockCells((DAnnotation)line)) {
                        String expression = (String)cell.getDetails().get((Object)"Content:");
                        if (!expression.contains("getLastModificationDate")) continue;
                        List annotations = Optional.ofNullable((List)titleBlockCells.get(notifier)).orElse(new ArrayList());
                        titleBlockCells.put((DRepresentationDescriptor)notifier, annotations);
                        annotations.add(cell);
                    }
                }
            }
        }
        if (!titleBlockCells.isEmpty()) {
            RecordingCommand changeIdRecordingCommand = new RecordingCommand(this.siriuSession.getTransactionalEditingDomain()){

                protected void doExecute() {
                    for (DRepresentationDescriptor repDesc : titleBlockCells.keySet()) {
                        for (DAnnotation cell : (List)titleBlockCells.get(repDesc)) {
                            String expression = (String)cell.getDetails().get((Object)"Content:");
                            try {
                                Object result = TitleBlockUpdaterListener.this.siriuSession.getInterpreter().evaluate((EObject)repDesc, expression);
                                if (result == null) continue;
                                for (EObject titleBlockContent : cell.getReferences()) {
                                    if (!(titleBlockContent instanceof DAnnotation)) continue;
                                    ((DAnnotation)titleBlockContent).getDetails().put((Object)"Content:", (Object)result.toString());
                                    List titleBlockContentNodeListElement = new EObjectQuery(titleBlockContent).getInverseReferences(ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET).stream().filter(DNodeListElement.class::isInstance).map(DNodeListElement.class::cast).collect(Collectors.toList());
                                    for (DNodeListElement nodeListELement : titleBlockContentNodeListElement) {
                                        DDiagramElementSynchronizer dDiagramElementSynchronizer = new DDiagramElementSynchronizer((DSemanticDiagram)repDesc.getRepresentation(), TitleBlockUpdaterListener.this.siriuSession.getInterpreter(), TitleBlockUpdaterListener.this.siriuSession.getModelAccessor());
                                        dDiagramElementSynchronizer.refresh((DDiagramElement)nodeListELement);
                                    }
                                }
                            }
                            catch (EvaluationException evaluationException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            return changeIdRecordingCommand;
        }
        return null;
    }
}

