/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.impl.policies;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;

public class DefaultMergePolicy<E>
implements IMergePolicy<E> {
    @Override
    public boolean bindPresenceToOwnership(ITreeDataScope<E> scope_p) {
        return true;
    }

    @Override
    public boolean copyAttribute(Object attribute_p, ITreeDataScope<E> scope_p) {
        return scope_p.mIsChangeableAttribute(attribute_p);
    }

    @Override
    public boolean copyReference(Object reference_p, ITreeDataScope<E> scope_p) {
        return scope_p.mIsChangeableReference(reference_p);
    }

    protected boolean copyExtrinsicIDs(ITreeDataScope<E> sourceScope_p, ITreeDataScope<E> targetScope_p) {
        return true;
    }

    @Override
    public boolean copyOutOfScopeCrossReferences(ITreeDataScope<E> sourceScope_p, ITreeDataScope<E> targetScope_p) {
        return true;
    }

    @Override
    public Set<E> getAdditionGroup(E element_p, ITreeDataScope<E> scope_p) {
        FHashSet result = new FHashSet();
        for (Object reference : scope_p.mGetReferences(element_p)) {
            if (!scope_p.mIsChangeableReference(reference) || scope_p.mIsContainerReference(reference) || scope_p.mIsContainmentReference(reference) && this.bindPresenceToOwnership(scope_p) || !this.isMandatoryForAddition(element_p, reference, scope_p)) continue;
            result.addAll(scope_p.getReferenceValues(element_p, reference));
        }
        return result;
    }

    @Override
    public Set<E> getDeletionGroup(E element_p, ITreeDataScope<E> scope_p) {
        FHashSet result = new FHashSet();
        for (Object reference : scope_p.mGetReferences(element_p)) {
            if (!scope_p.mIsChangeableReference(reference) || scope_p.mIsContainerReference(reference) || scope_p.mIsContainmentReference(reference) && this.bindPresenceToOwnership(scope_p) || !this.isMandatoryForDeletion(element_p, reference, scope_p)) continue;
            result.addAll(scope_p.getReferenceValues(element_p, reference));
        }
        return result;
    }

    @Override
    public int getDesiredValuePosition(IComparison<E> comparison_p, Role destination_p, IMatch<E> source_p, Object reference_p, E sourceValue_p) {
        Object sourceHolder = source_p.get(destination_p.opposite());
        Object destinationHolder = source_p.get(destination_p);
        if (sourceHolder != null && destinationHolder != null && sourceValue_p != null) {
            int start;
            ITreeDataScope sourceScope = comparison_p.getScope(destination_p.opposite());
            ITreeDataScope destinationScope = comparison_p.getScope(destination_p);
            List sourceValues = sourceScope.getReferenceValues(sourceHolder, reference_p);
            List destinationValues = destinationScope.getReferenceValues(destinationHolder, reference_p);
            int i = start = sourceValues.indexOf(sourceValue_p) + 1;
            while (i < sourceValues.size()) {
                int nextDestinationIndex;
                Object nextDestinationElement;
                Object nextSourceElement = sourceValues.get(i);
                IMatch<E> nextMatch = comparison_p.getMapping().getMatchFor(nextSourceElement, destination_p.opposite());
                if (nextMatch != null && (nextDestinationElement = nextMatch.get(destination_p)) != null && (nextDestinationIndex = destinationValues.indexOf(nextDestinationElement)) >= 0) {
                    return nextDestinationIndex;
                }
                ++i;
            }
        }
        return -1;
    }

    protected Object getNewIntrinsicID(E element_p, ITreeDataScope<E> scope_p) {
        return null;
    }

    @Override
    public boolean isMandatoryForAddition(E element_p, Object reference_p, ITreeDataScope<E> scope_p) {
        return this.isSingleMandatory(reference_p, scope_p);
    }

    @Override
    public boolean isMandatoryForDeletion(E element_p, Object reference_p, ITreeDataScope<E> scope_p) {
        Object opposite = scope_p.mGetOppositeReference(reference_p);
        return opposite != null && this.isSingleMandatory(opposite, scope_p);
    }

    protected boolean isSingleMandatory(Object reference_p, ITreeDataScope<E> scope_p) {
        return !scope_p.mIsManyReference(reference_p) && !scope_p.mIsOptionalReference(reference_p);
    }

    protected boolean requiresNewIntrinsicID(E element_p, ITreeDataScope<E> scope_p) {
        return false;
    }

    @Override
    public void setID(E source_p, ITreeDataScope<E> sourceScope_p, E target_p, ITreeDataScope<E> targetScope_p) {
        if (this.copyExtrinsicIDs(sourceScope_p, targetScope_p)) {
            Object extrinsicID = sourceScope_p.tGetID(source_p, false);
            targetScope_p.tSetID(target_p, extrinsicID, false);
        }
        if (this.requiresNewIntrinsicID(target_p, targetScope_p)) {
            Object newID = this.getNewIntrinsicID(target_p, targetScope_p);
            targetScope_p.tSetID(target_p, newID, true);
        }
    }
}

