/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerFactory;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreateEngSystemCmd
extends AbstractReadWriteCommand {
    private String systemEngName;
    private SystemEngineering systemEng;
    private Project project;

    public CreateEngSystemCmd(Project prj, String systemName) {
        if (systemName == null) {
            throw new IllegalArgumentException("The system engineering name parameter cannot be null !");
        }
        if (prj == null) {
            throw new IllegalArgumentException("The Capella project parameter cannot be null !");
        }
        this.project = prj;
        this.systemEngName = systemName;
    }

    public void run() {
        this.systemEng = CapellamodellerFactory.eINSTANCE.createSystemEngineering(this.systemEngName);
        this.project.getOwnedModelRoots().add((Object)this.systemEng);
    }

    public String getName() {
        return Messages.getString("capella.sys_eng.create.cmd");
    }

    public SystemEngineering getSystemEngineering() {
        return this.systemEng;
    }
}

