/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolvementHelper;

public class PhysicalPathInvolvementHelper {
    private static PhysicalPathInvolvementHelper instance;

    private PhysicalPathInvolvementHelper() {
    }

    public static PhysicalPathInvolvementHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalPathInvolvementHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalPathInvolvement element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CsPackage.Literals.PHYSICAL_PATH_INVOLVEMENT__INVOLVED_ELEMENT)) {
            ret = this.getInvolvedElement(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_PATH_INVOLVEMENT__INVOLVED_COMPONENT)) {
            ret = this.getInvolvedComponent(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_PATH_INVOLVEMENT__PREVIOUS_INVOLVEMENTS)) {
            ret = this.getPreviousInvolvements(element);
        }
        if (ret == null) {
            ret = InvolvementHelper.getInstance().doSwitch((Involvement)element, feature);
        }
        return ret;
    }

    protected AbstractPathInvolvedElement getInvolvedElement(PhysicalPathInvolvement element) {
        InvolvedElement involvedElement;
        if (element != null && (involvedElement = element.getInvolved()) instanceof AbstractPathInvolvedElement) {
            return (AbstractPathInvolvedElement)involvedElement;
        }
        return null;
    }

    protected Component getInvolvedComponent(PhysicalPathInvolvement element) {
        Type type;
        InvolvedElement involvedElement;
        if (element != null && (involvedElement = element.getInvolved()) instanceof Part && (type = ((Part)involvedElement).getType()) instanceof Component) {
            return (Component)type;
        }
        return null;
    }

    protected List<PhysicalPathInvolvement> getPreviousInvolvements(PhysicalPathInvolvement element) {
        ArrayList<PhysicalPathInvolvement> ret = new ArrayList<PhysicalPathInvolvement>();
        EObject owner = element.eContainer();
        if (owner instanceof PhysicalPath) {
            for (EObject anInverseReference : EObjectExt.getReferencers((EObject)element, (EReference)CsPackage.Literals.PHYSICAL_PATH_INVOLVEMENT__NEXT_INVOLVEMENTS)) {
                if (!(anInverseReference instanceof PhysicalPathInvolvement) || !((PhysicalPath)owner).getOwnedPhysicalPathInvolvements().contains((Object)anInverseReference)) continue;
                ret.add((PhysicalPathInvolvement)anInverseReference);
            }
        }
        return ret;
    }
}

