/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.GeneralClass;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.GeneralClassHelper;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.InformationRealization;

public class ClassHelper {
    private static ClassHelper instance;

    private ClassHelper() {
    }

    public static ClassHelper getInstance() {
        if (instance == null) {
            instance = new ClassHelper();
        }
        return instance;
    }

    public Object doSwitch(Class element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(InformationPackage.Literals.CLASS__REALIZED_CLASSES)) {
            ret = this.getRealizedClasses(element);
        } else if (feature.equals(InformationPackage.Literals.CLASS__REALIZING_CLASSES)) {
            ret = this.getRealizingClasses(element);
        }
        if (ret == null) {
            ret = GeneralClassHelper.getInstance().doSwitch((GeneralClass)element, feature);
        }
        return ret;
    }

    protected List<Class> getRealizedClasses(Class element) {
        ArrayList<Class> ret = new ArrayList<Class>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof InformationRealization) || !((elt = trace.getTargetElement()) instanceof Class)) continue;
            ret.add((Class)elt);
        }
        return ret;
    }

    protected List<Class> getRealizingClasses(Class element) {
        ArrayList<Class> ret = new ArrayList<Class>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof InformationRealization) || !((elt = trace.getSourceElement()) instanceof Class)) continue;
            ret.add((Class)elt);
        }
        return ret;
    }
}

