/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.interaction.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.polarsys.capella.core.data.helpers.interaction.services.ScenarioExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;

public class SequenceMessageExt {
    public static void resetMessage(SequenceMessage sequenceMessage) {
        Event evt;
        MessageEnd sndMsgEnd;
        Event evt2;
        MessageEnd rcvMsgEnd = sequenceMessage.getReceivingEnd();
        if (rcvMsgEnd != null && (evt2 = rcvMsgEnd.getEvent()) instanceof EventReceiptOperation) {
            ((EventReceiptOperation)evt2).setOperation(null);
        }
        if ((sndMsgEnd = sequenceMessage.getSendingEnd()) != null && (evt = sndMsgEnd.getEvent()) instanceof EventSentOperation) {
            ((EventSentOperation)evt).setOperation(null);
        }
        sequenceMessage.setName("");
    }

    public static AbstractEventOperation getOperation(SequenceMessage sequenceMessage) {
        Event evt;
        Event evt2;
        MessageEnd rcvMsgEnd = sequenceMessage.getReceivingEnd();
        if (rcvMsgEnd != null && (evt2 = rcvMsgEnd.getEvent()) instanceof EventReceiptOperation) {
            EventReceiptOperation evtOp = (EventReceiptOperation)evt2;
            return evtOp.getOperation();
        }
        MessageEnd sndMsgEnd = sequenceMessage.getSendingEnd();
        if (sndMsgEnd != null && (evt = sndMsgEnd.getEvent()) instanceof EventSentOperation) {
            EventSentOperation evtOp = (EventSentOperation)evt;
            return evtOp.getOperation();
        }
        return null;
    }

    public static AbstractEventOperation getFunctionalExchange(SequenceMessage sequenceMessage) {
        EventSentOperation evtOp;
        Event evt;
        EventReceiptOperation evtOp2;
        Event evt2;
        MessageEnd rcvMsgEnd = sequenceMessage.getReceivingEnd();
        if (rcvMsgEnd != null && (evt2 = rcvMsgEnd.getEvent()) instanceof EventReceiptOperation && (evtOp2 = (EventReceiptOperation)evt2).getOperation() != null) {
            return evtOp2.getOperation();
        }
        MessageEnd sndMsgEnd = sequenceMessage.getSendingEnd();
        if (sndMsgEnd != null && (evt = sndMsgEnd.getEvent()) instanceof EventSentOperation && (evtOp = (EventSentOperation)evt).getOperation() != null) {
            return evtOp.getOperation();
        }
        return null;
    }

    public static List<SequenceMessage> reverse(List<SequenceMessage> list) {
        ArrayList<SequenceMessage> reversedList = new ArrayList<SequenceMessage>();
        ListIterator<SequenceMessage> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            reversedList.add(iterator.previous());
        }
        return reversedList;
    }

    public static SequenceMessage findReplySequenceMessage(SequenceMessage sequenceMessage) {
        ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)sequenceMessage.getReceivingEnd());
        for (EStructuralFeature.Setting setting : crossReferenceAdapter.getInverseReferences((EObject)sequenceMessage.getReceivingEnd())) {
            if (!(setting.getEObject() instanceof Execution) || setting.getEStructuralFeature() != InteractionPackage.eINSTANCE.getTimeLapse_Start()) continue;
            return ((MessageEnd)((Execution)setting.getEObject()).getFinish()).getMessage();
        }
        return null;
    }

    public static SequenceMessage getOppositeSequenceMessage(SequenceMessage sequenceMessage1) {
        Scenario sc;
        boolean flag = false;
        List<SequenceMessage> setPortionMessage = new ArrayList<SequenceMessage>();
        Stack<SequenceMessage> stack = new Stack<SequenceMessage>();
        if (!(sequenceMessage1 == null || sequenceMessage1.getKind().equals((Object)MessageKind.CREATE) || sequenceMessage1.getKind().equals((Object)MessageKind.DELETE) || sequenceMessage1.getKind().equals((Object)MessageKind.ASYNCHRONOUS_CALL) || (sc = (Scenario)sequenceMessage1.eContainer()) == null)) {
            if (sequenceMessage1.getKind().equals((Object)MessageKind.REPLY)) {
                flag = false;
                Iterator<MessageEnd> it = ScenarioExt.getOwnedMessagesEnds(sc).iterator();
                while (it.hasNext() && !flag) {
                    MessageEnd msgEnd = it.next();
                    if (msgEnd == null || (msg = msgEnd.getMessage()) == null) continue;
                    if (!msg.equals(sequenceMessage1)) {
                        setPortionMessage.add(msg);
                        continue;
                    }
                    flag = true;
                }
                setPortionMessage = SequenceMessageExt.reverse(setPortionMessage);
            } else {
                flag = false;
                for (MessageEnd msgEnd : ScenarioExt.getOwnedMessagesEnds(sc)) {
                    if (msgEnd == null || (msg = msgEnd.getMessage()) == null) continue;
                    if (flag) {
                        setPortionMessage.add(msg);
                        continue;
                    }
                    if (!msg.equals(sequenceMessage1)) continue;
                    flag = true;
                }
            }
            for (SequenceMessage msg : setPortionMessage) {
                if (msg.getKind().equals((Object)MessageKind.CREATE) || msg.getKind().equals((Object)MessageKind.DELETE) || msg.getKind().equals((Object)MessageKind.ASYNCHRONOUS_CALL)) continue;
                if (sequenceMessage1.getKind().equals((Object)MessageKind.REPLY)) {
                    if (msg.getKind().equals((Object)MessageKind.REPLY)) {
                        stack.push(msg);
                        continue;
                    }
                    if (stack.isEmpty()) {
                        return msg;
                    }
                    stack.pop();
                    continue;
                }
                if (msg.getKind().equals((Object)MessageKind.REPLY)) {
                    if (stack.isEmpty()) {
                        return msg;
                    }
                    stack.pop();
                    continue;
                }
                stack.push(msg);
            }
        }
        return null;
    }
}

