/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.MergeLink;
import org.polarsys.capella.core.data.interaction.RefinementLink;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.extension.TraceExtensionManager;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;

public class TraceNameHelper {
    public static String getTraceNameFromClass(Class<? extends AbstractTrace> clazz_p, ResourceSet context) {
        String result = null;
        String extensionTraceName = TraceExtensionManager.eINSTANCE.getTraceName(clazz_p, context);
        result = extensionTraceName != null ? extensionTraceName : (GenericTrace.class.isAssignableFrom(clazz_p) ? Messages.getString("TraceType.name.generic") : (MergeLink.class.isAssignableFrom(clazz_p) ? Messages.getString("TraceType.name.merge") : (RefinementLink.class.isAssignableFrom(clazz_p) ? Messages.getString("TraceType.name.refinement") : Messages.getString("TraceType.name.undefined"))));
        return result;
    }

    public static Trace getNewTraceInstanceFromTraceName(String className_p, ResourceSet context) {
        Trace result = TraceExtensionManager.eINSTANCE.getNewTraceInstanceFromTraceName(className_p, context);
        if (result != null) {
            return result;
        }
        if (className_p.equals(Messages.getString("TraceType.name.generic"))) {
            result = CapellacommonFactory.eINSTANCE.createGenericTrace();
        } else if (className_p.equals(Messages.getString("TraceType.name.merge"))) {
            result = InteractionFactory.eINSTANCE.createMergeLink();
        } else if (className_p.equals(Messages.getString("TraceType.name.refinement"))) {
            result = InteractionFactory.eINSTANCE.createRefinementLink();
        }
        return result;
    }

    public static List<String> getTraceTypes(ResourceSet context) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(TraceExtensionManager.eINSTANCE.getAllTraceTypes(context));
        result.add(Messages.getString("TraceType.name.generic"));
        result.add(Messages.getString("TraceType.name.merge"));
        result.add(Messages.getString("TraceType.name.refinement"));
        return result;
    }

    public static List<String> getManualTraceTypes(ResourceSet context) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(TraceExtensionManager.eINSTANCE.getAllManualTraceTypes(context));
        result.add(Messages.getString("TraceType.name.generic"));
        return result;
    }
}

