/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class DisconnectRepositoryAction
extends Action
implements ISelectionChangedListener {
    public static final String LABEL = Messages.DisconnectRepositoryAction_Disconnected;
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.offline";
    private TaskRepository repository;

    public DisconnectRepositoryAction() {
        super(LABEL, 2);
        this.setId(ID);
        this.setEnabled(false);
    }

    public void run() {
        this.repository.setOffline(this.isChecked());
        TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.OFFLINE));
    }

    @Deprecated
    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        AbstractRepositoryConnector connector;
        Object selectedObject;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof TaskRepository && (connector = TasksUi.getRepositoryManager().getRepositoryConnector(((TaskRepository)selectedObject).getConnectorKind())).isUserManaged()) {
            this.repository = (TaskRepository)selectedObject;
            this.setChecked(this.repository.isOffline());
            this.setEnabled(true);
            return;
        }
        this.repository = null;
        this.setChecked(false);
        this.setEnabled(false);
    }
}

