/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.emf.diffmerge.diffdata.EElementRelativePresence;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.ui.util.DiffDecoratingLabelProvider;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategory;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractDifferenceCategory;

public class TextualCategoryFilter
extends AbstractDifferenceCategory {
    protected ComparisonTreeViewer treeViewer;
    private StringMatcher matcher;
    private static final Pattern NON_WORD = Pattern.compile("\\W+", 256);
    String matchString = "";
    Map<Object, Boolean> visibilityCache = new HashMap<Object, Boolean>();
    boolean isActive = true;

    public TextualCategoryFilter(ComparisonTreeViewer treeViewer_p) {
        this.treeViewer = treeViewer_p;
    }

    @Override
    public IDifferenceCategory copy() {
        TextualCategoryFilter copy = new TextualCategoryFilter(this.treeViewer);
        copy.copyState(this);
        return copy;
    }

    @Override
    public void copyState(IDifferenceCategory peer_p) {
        TextualCategoryFilter toCopy = (TextualCategoryFilter)peer_p;
        toCopy.matchString = this.matchString;
        toCopy.matcher = this.matcher;
        toCopy.isActive = this.isActive;
        super.copyState(peer_p);
    }

    @Override
    public boolean covers(IDifference<?> difference_p, EMFDiffNode node_p) {
        if (difference_p instanceof EElementRelativePresence) {
            Boolean visible = this.visibilityCache.get(difference_p);
            if (visible == null) {
                boolean textMatches = false;
                EElementRelativePresence eElementPresence = (EElementRelativePresence)difference_p;
                EMatch ownerMatch = eElementPresence.getElementMatch();
                String label = ((DiffDecoratingLabelProvider)this.treeViewer.getLabelProvider()).getUndecoratedText(ownerMatch);
                textMatches = this.wordMatches(label);
                visible = textMatches;
                this.visibilityCache.put(difference_p, visible);
            }
            return visible == false;
        }
        return false;
    }

    @Override
    public String getID() {
        return "textualFilter";
    }

    @Override
    public String getText(EMFDiffNode node_p) {
        return "Textual Category Filter";
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active_p) {
        this.isActive = active_p;
    }

    @Override
    public boolean isApplicable(EMFDiffNode node_p) {
        return true;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    public void textChanged(String inputString) {
        if (inputString == null || !inputString.equals(this.matchString)) {
            this.clearCache();
            this.matchString = inputString;
            if (inputString == null || inputString.isEmpty()) {
                this.matcher = null;
                this.setActive(false);
            } else {
                this.setActive(true);
                String pattern = "*" + inputString + "*";
                this.matcher = new StringMatcher(pattern, true, false);
            }
        }
    }

    protected void clearCache() {
        this.visibilityCache.clear();
    }

    private String[] getWords(String text) {
        return NON_WORD.split(text, 0);
    }

    protected boolean wordMatches(String text) {
        String[] words;
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] stringArray = words = this.getWords(text);
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.match(word)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean match(String string) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(string);
    }
}

