/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.match;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.ui.search.match.SearchMatch;
import org.polarsys.capella.core.ui.search.match.SearchMatchChild;

public class LineSearchMatchChild
extends SearchMatchChild {
    private int lineNumber;

    public LineSearchMatchChild(Object source, String text, IProject project, SearchMatch parent, int lineNumber) {
        super(source, text, project, parent);
        this.lineNumber = lineNumber;
    }

    @Override
    public boolean replace(Pattern searchPattern, String replacement) {
        String fullText;
        String[] fullTextLines;
        EAttribute eAttribute;
        EObject eObject;
        Object fullValue;
        Object attribute = this.getParent().getAttribute();
        Object object = this.getParent().getElement();
        if (attribute instanceof EAttribute && object instanceof EObject && (fullValue = (eObject = (EObject)object).eGet((EStructuralFeature)(eAttribute = (EAttribute)attribute))) instanceof String && this.lineNumber < (fullTextLines = (fullText = (String)fullValue).split("\n")).length) {
            String modifiedLine;
            String lineToModify = fullTextLines[this.lineNumber];
            fullTextLines[this.lineNumber] = modifiedLine = searchPattern.matcher(lineToModify).replaceAll(replacement);
            String modifiedFullText = Arrays.stream(fullTextLines).collect(Collectors.joining("\n"));
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)eObject);
            Command setCommand = SetCommand.create((EditingDomain)domain, (Object)eObject, (Object)eAttribute, (Object)modifiedFullText);
            domain.getCommandStack().execute(setCommand);
            this.setOriginalText(modifiedLine);
            return true;
        }
        return false;
    }

    @Override
    protected String computeDisplayedText(String originalText) {
        return String.valueOf(this.lineNumber) + ": " + super.computeDisplayedText(originalText);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.lineNumber);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LineSearchMatchChild)) {
            return false;
        }
        LineSearchMatchChild other = (LineSearchMatchChild)((Object)obj);
        return this.lineNumber == other.lineNumber;
    }
}

