/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.RepositoryRegistry;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.DeletePatternOperation;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations.CloseCatalogOperation;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations.CreateCatalogOperation;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations.OpenCatalogOperation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRepositorySelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternBasedSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.ITemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplateUsageSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.TemplateUsageDialog;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.providers.NameBasedLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternPage;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.AbstractPatternWizard;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.PatternWizardDialog;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.templates.TemplateUsageWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPatternPresentationPage<T extends ITemplatePatternBasedSpecification>
extends AbstractPatternPage<T> {
    protected final PatternSelectionKind _patternSelection;
    protected final boolean _patternIsEditable;
    protected ComboViewer _repositoryViewer;
    protected ComboViewer _patternViewer;
    protected Text _versionWidget;

    public AbstractPatternPresentationPage(String pageName_p, String pageTitle_p, String defaultMessage_p, T data_p, boolean isBlocking_p, PatternSelectionKind patternSelection_p, boolean patternIsEditable_p) {
        super(pageName_p, pageTitle_p, defaultMessage_p, data_p, isBlocking_p);
        this._patternSelection = patternSelection_p;
        this._patternIsEditable = patternIsEditable_p;
        this._repositoryViewer = null;
        this._patternViewer = null;
        this._versionWidget = null;
    }

    protected void createAuthorsRow(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractPatternPresentationPage_Authors);
        final Text text = new Text(parent_p, 2050);
        if (this.getData().getPattern() != null) {
            text.setText(this.getMultiEntryString((Iterable<String>)this.getData().getPattern().getAuthors()));
        }
        boolean MIN_HEIGHT = true;
        GridData data = new GridData();
        data.verticalSpan = 1;
        data.verticalAlignment = 4;
        data.horizontalSpan = this.getGridColumnsNb() - 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        int i = 0;
        while (i < 0) {
            this.addEmptyControl(parent_p);
            ++i;
        }
        text.setEditable(this._patternIsEditable);
        if (this._patternIsEditable) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e_p) {
                    String value = text.getText();
                    AbstractPatternPresentationPage.this.getData().getPattern().getAuthors().clear();
                    AbstractPatternPresentationPage.this.getData().getPattern().getAuthors().addAll(UIUtil.parseCommaSeparatedString(value));
                }
            });
        }
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    String newText = newPattern_p == null ? "" : AbstractPatternPresentationPage.this.getMultiEntryString((Iterable<String>)newPattern_p.getAuthors());
                    text.setText(newText);
                }
            });
        }
    }

    public void createControl(Composite parent_p) {
        RepositoryRegistry registry;
        Composite composite = new Composite(parent_p, 0);
        this.setControl((Control)composite);
        this.setDefaultMessage();
        this.createPatternPresentation(composite);
        IPatternRepository initialRepository = this.getData().getRepository();
        if (initialRepository == null && !(registry = CorePatternsPlugin.getDefault().getRepositoryRegistry()).getRepositories().isEmpty() && this._repositoryViewer != null) {
            this._repositoryViewer.setSelection((ISelection)new StructuredSelection(registry.getRepositories().iterator().next()));
        }
        TemplatePattern initialPattern = this.getData().getPattern();
        if (initialRepository != null && this._repositoryViewer != null) {
            this._repositoryViewer.setSelection((ISelection)new StructuredSelection((Object)initialRepository));
        }
        if (initialPattern != null && this._patternViewer != null) {
            this._patternViewer.setSelection((ISelection)new StructuredSelection((Object)initialPattern));
        }
    }

    protected void createPatternFilterRow(Composite parent_p) {
    }

    protected void createPatternPresentation(Composite parent_p) {
        GridLayout mainCompositeLayout = new GridLayout(this.getGridColumnsNb(), false);
        parent_p.setLayout((Layout)mainCompositeLayout);
        this._repositoryViewer = this.createRepositoryRow(parent_p);
        this.createPatternFilterRow(parent_p);
        this._patternViewer = this.createPatternRow(parent_p);
        this._versionWidget = this.createVersionRow(parent_p);
        this.createEnvironmentsRow(parent_p);
        this.createAuthorsRow(parent_p);
        this.createDescriptionRow(parent_p);
        this.createImageRow(parent_p);
        if (this._patternIsEditable) {
            this.createLayoutRow(parent_p);
            this.createTemplateButton(parent_p);
        }
    }

    protected Button createDeletePatternButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractPatternPresentationPage_Open);
        Point size = result.computeSize(-1, -1, true);
        result.setText(Messages.AbstractPatternPresentationPage_DeleteButton);
        GridData deleteGridData = new GridData(4, 4, false, false);
        deleteGridData.widthHint = size.x;
        result.setLayoutData((Object)deleteGridData);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                AbstractPatternPresentationPage.this.deletePattern();
            }
        });
        result.setEnabled(this.getData().getPattern() != null);
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    result.setEnabled(newPattern_p != null);
                }
            });
        }
        return result;
    }

    protected void createDescriptionRow(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractPatternPresentationPage_Description);
        final Text text = new Text(parent_p, 2626);
        if (this.getData().getPattern() != null) {
            text.setText(this.nonNull(this.getData().getPattern().getDescription()));
        }
        int MIN_HEIGHT = 4;
        GridData data = new GridData(4, 4, true, false, this.getGridColumnsNb() - 1, 4);
        text.setLayoutData((Object)data);
        int i = 0;
        while (i < 3) {
            this.addEmptyControl(parent_p);
            ++i;
        }
        text.setEditable(this._patternIsEditable);
        if (this._patternIsEditable) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e_p) {
                    String value = text.getText();
                    AbstractPatternPresentationPage.this.getData().getPattern().setDescription(value);
                }
            });
        }
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    String newText = newPattern_p == null ? "" : AbstractPatternPresentationPage.this.nonNull(newPattern_p.getDescription());
                    text.setText(newText);
                }
            });
        }
    }

    protected void createEnvironmentsRow(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractPatternPresentationPage_Environments);
        final Text text = new Text(parent_p, 2050);
        if (this.getData().getPattern() != null) {
            text.setText(this.getMultiEntryString((Iterable<String>)this.getData().getPattern().getExecutionEnvironments()));
        }
        boolean MIN_HEIGHT = true;
        GridData data = new GridData();
        data.verticalSpan = 1;
        data.verticalAlignment = 4;
        data.horizontalSpan = this.getGridColumnsNb() - 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        int i = 0;
        while (i < 0) {
            this.addEmptyControl(parent_p);
            ++i;
        }
        text.setEditable(this._patternIsEditable);
        if (this._patternIsEditable) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e_p) {
                    String value = text.getText();
                    AbstractPatternPresentationPage.this.getData().getPattern().getExecutionEnvironments().clear();
                    AbstractPatternPresentationPage.this.getData().getPattern().getExecutionEnvironments().addAll(UIUtil.parseCommaSeparatedString(value));
                }
            });
        }
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    String newText = newPattern_p == null ? "" : AbstractPatternPresentationPage.this.getMultiEntryString((Iterable<String>)newPattern_p.getExecutionEnvironments());
                    text.setText(newText);
                }
            });
        }
    }

    protected void createImageRow(Composite parent_p) {
        Label leftControl;
        String leftControlText = Messages.AbstractPatternPresentationPage_Image;
        if (this._patternIsEditable) {
            final IModifiableTemplatePatternSpecification modifiableData = (IModifiableTemplatePatternSpecification)this.getData();
            final Button checkButton = new Button(parent_p, 32);
            checkButton.setText(leftControlText);
            checkButton.setSelection(modifiableData.acceptNewPatternImage());
            checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = checkButton.getSelection();
                    modifiableData.setAcceptNewPatternImage(selected);
                    if (selected) {
                        AbstractPatternPresentationPage.this.getWizard().computePatternImageFromGraphicalContext(true);
                    } else {
                        AbstractPatternPresentationPage.this.setPatternImageToDefault();
                    }
                }
            });
            checkButton.setEnabled(this.getWizard().mayHaveImage());
            leftControl = checkButton;
        } else {
            leftControl = new Label(parent_p, 0);
            leftControl.setText(leftControlText);
        }
        GridData gd = new GridData(16384, 128, false, false);
        leftControl.setLayoutData((Object)gd);
        final Canvas canvas = new Canvas(parent_p, 2048);
        boolean MIN_HEIGHT = true;
        GridData data = new GridData(4, 4, true, true, this.getGridColumnsNb() - 1, 1);
        canvas.setLayoutData((Object)data);
        int i = 0;
        while (i < 0) {
            this.addEmptyControl(parent_p);
            ++i;
        }
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e_p) {
                Image image = AbstractPatternPresentationPage.this.getWizard().getPatternImage();
                if (image != null) {
                    int maxWidth = canvas.getBounds().width;
                    int maxHeight = canvas.getBounds().height;
                    ImageData imageData = null;
                    try {
                        imageData = image.getImageData();
                        Point newSize = UIUtil.getBoundedImageSize(imageData, maxWidth, maxHeight);
                        e_p.gc.drawImage(image, 0, 0, imageData.width, imageData.height, 0, 0, newSize.x, newSize.y);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.getWizard().addSelectedPatternListener(new AbstractPatternWizard.IPatternImageChangedListener(){

            @Override
            public void patternImageChanged(Image newImage_p) {
                if (!canvas.isDisposed()) {
                    canvas.redraw();
                }
            }
        });
    }

    protected void createLayoutRow(Composite parent_p) {
        final Button includeLayoutButton = new Button(parent_p, 32);
        includeLayoutButton.setText(Messages.AbstractPatternPresentationPage_IncludeLayoutAndStyle);
        final IModifiableTemplatePatternSpecification modifiableData = (IModifiableTemplatePatternSpecification)this.getData();
        includeLayoutButton.setSelection(this.getWizard().mayHaveImage() && modifiableData.includeLayoutData());
        includeLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = includeLayoutButton.getSelection();
                modifiableData.setIncludeLayoutData(selected);
            }
        });
        includeLayoutButton.setEnabled(this.getWizard().mayHaveImage());
        GridData gd = new GridData(16384, 128, false, false, this.getGridColumnsNb(), 1);
        includeLayoutButton.setLayoutData((Object)gd);
    }

    protected ComboViewer createPatternRow(Composite parent_p) {
        ComboViewer result;
        if (this._patternIsEditable) {
            this.createEditablePatternRow(parent_p);
            result = null;
        } else {
            result = this.createExistingPatternRow(parent_p);
        }
        return result;
    }

    protected ComboViewer createExistingPatternRow(Composite parent_p) {
        new Label(parent_p, 0).setText(this.getExistingPatternRowLabel());
        Composite group = new Composite(parent_p, 0);
        GridData groupData = new GridData(4, 4, true, false);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.marginHeight = 0;
        groupLayout.marginWidth = 0;
        group.setLayoutData((Object)groupData);
        group.setLayout((Layout)groupLayout);
        Combo combo = new Combo(group, 2060);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gd);
        final ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setLabelProvider((IBaseLabelProvider)DiscriminatingLabelProvider.getInstance());
        comboViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
                boolean result = false;
                if (element_p instanceof TemplatePattern) {
                    result = AbstractPatternPresentationPage.this.getData().isAcceptable((TemplatePattern)element_p);
                }
                return result;
            }
        });
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement_p) {
                Object[] result = new Object[]{};
                if (inputElement_p instanceof IPatternRepository) {
                    IPatternRepository repository = (IPatternRepository)inputElement_p;
                    result = repository.getPatterns().toArray();
                }
                return result;
            }
        });
        comboViewer.setComparator(new ViewerComparator());
        if (this.getData() instanceof IRepositorySelection) {
            comboViewer.setInput((Object)((IRepositorySelection)this.getData()).getRepository());
        }
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IStructuredSelection selection = (IStructuredSelection)comboViewer.getSelection();
                Object selected = selection.getFirstElement();
                if (selected instanceof TemplatePattern && AbstractPatternPresentationPage.this.getData() instanceof ITemplatePatternSelection) {
                    ((ITemplatePatternSelection)AbstractPatternPresentationPage.this.getData()).setPattern((TemplatePattern)selected);
                    AbstractPatternPresentationPage.this.validate();
                }
            }
        });
        if (this.getData() instanceof IRepositorySelection) {
            ((IRepositorySelection)this.getData()).addSelectedRepositoryListener(new IRepositorySelection.IRepositoryChangedListener(){

                public void repositoryChanged(IPatternRepository newRepository_p) {
                    comboViewer.setInput((Object)newRepository_p);
                    TemplatePattern defaultPattern = null;
                    if (newRepository_p != null) {
                        for (IPattern pattern : newRepository_p.getPatterns()) {
                            if (!(pattern instanceof TemplatePattern)) continue;
                            TemplatePattern current = (TemplatePattern)newRepository_p.getPatterns().get(0);
                            if (!AbstractPatternPresentationPage.this.getData().isAcceptable(current)) continue;
                            defaultPattern = current;
                            break;
                        }
                    }
                    comboViewer.setSelection((ISelection)AbstractPatternPage.NonUserSelection.newInstance(defaultPattern));
                    if (AbstractPatternPresentationPage.this.getData() instanceof ITemplatePatternSelection) {
                        ((ITemplatePatternSelection)AbstractPatternPresentationPage.this.getData()).setPattern(defaultPattern);
                        AbstractPatternPresentationPage.this.validate();
                    }
                }
            });
        }
        if (this._patternSelection == PatternSelectionKind.SELECTABLE_WITH_DELETE) {
            this.createDeletePatternButton(group);
        }
        this.finishRow(parent_p, true);
        return comboViewer;
    }

    protected Text createEditablePatternRow(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractPatternPresentationPage_Name);
        final Text result = new Text(parent_p, 2052);
        if (this.getData().getPattern() != null) {
            result.setText(this.getData().getPattern().getName());
        }
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                String value = result.getText();
                AbstractPatternPresentationPage.this.getData().getPattern().setName(value);
                AbstractPatternPresentationPage.this.validate();
            }
        });
        this.finishRow(parent_p, true);
        this.selectTextContent(result);
        return result;
    }

    protected ComboViewer createRepositoryRow(Composite parent_p) {
        ComboViewer result = null;
        new Label(parent_p, 0).setText(Messages.AbstractPatternPresentationPage_Catalog);
        if (this._patternSelection == PatternSelectionKind.FIXED) {
            Text text = new Text(parent_p, 2048);
            PatternRepository repository = (PatternRepository)this.getData().getRepository();
            text.setText(NameBasedLabelProvider.getInstance().getText(repository));
            text.setEditable(false);
            GridData gd = new GridData(4, 4, true, false, 3, 1);
            text.setLayoutData((Object)gd);
        } else {
            result = this.createRepositorySelectionRow(parent_p);
        }
        this.finishRow(parent_p, false);
        return result;
    }

    protected ComboViewer createRepositorySelectionRow(Composite parent_p) {
        ComboViewer result = this.createRepositoryChoiceViewer(parent_p);
        Composite buttonsGroup = new Composite(parent_p, 0);
        int nbButtons = this._patternSelection == PatternSelectionKind.NEW ? 3 : 2;
        buttonsGroup.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout buttonsGroupLayout = new GridLayout(nbButtons, true);
        buttonsGroupLayout.marginHeight = 0;
        buttonsGroupLayout.marginWidth = 0;
        buttonsGroup.setLayout((Layout)buttonsGroupLayout);
        this.createRepositoryOpenButton(buttonsGroup, (StructuredViewer)result);
        this.createRepositoryCloseButton(buttonsGroup, result);
        if (this._patternSelection == PatternSelectionKind.NEW) {
            this.createRepositoryNewButton(buttonsGroup, (StructuredViewer)result);
        }
        RepositoryRegistry registry = CorePatternsPlugin.getDefault().getRepositoryRegistry();
        result.setInput((Object)registry);
        return result;
    }

    protected ComboViewer createRepositoryChoiceViewer(Composite parent_p) {
        Combo combo = new Combo(parent_p, 2060);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gd);
        final ComboViewer result = new ComboViewer(combo);
        result.setLabelProvider((IBaseLabelProvider)NameBasedLabelProvider.getInstance());
        result.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement_p) {
                Object[] elements = new Object[]{};
                if (inputElement_p instanceof RepositoryRegistry) {
                    RepositoryRegistry registry = (RepositoryRegistry)inputElement_p;
                    elements = registry.getRepositories().toArray();
                }
                return elements;
            }
        });
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IStructuredSelection selection = (IStructuredSelection)result.getSelection();
                if (AbstractPatternPresentationPage.this.getData() instanceof IRepositorySelection) {
                    IPatternRepository selected = null;
                    if (!selection.isEmpty()) {
                        selected = (IPatternRepository)selection.getFirstElement();
                    }
                    ((IRepositorySelection)AbstractPatternPresentationPage.this.getData()).setRepository(selected);
                    AbstractPatternPresentationPage.this.validate();
                }
            }
        });
        result.setComparator(new ViewerComparator());
        return result;
    }

    protected Button createRepositoryCloseButton(Composite parent_p, final ComboViewer repositoryViewer_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractPatternPresentationPage_Close);
        result.setLayoutData((Object)new GridData(4, 4, false, false));
        result.setEnabled(false);
        if (this.getData() instanceof IRepositorySelection) {
            ((IRepositorySelection)this.getData()).addSelectedRepositoryListener(new IRepositorySelection.IRepositoryChangedListener(){

                public void repositoryChanged(IPatternRepository newRepository_p) {
                    result.setEnabled(newRepository_p != null);
                }
            });
        }
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)repositoryViewer_p.getSelection();
                if (!selection.isEmpty()) {
                    int selectionIndex = repositoryViewer_p.getCombo().getSelectionIndex();
                    IPatternRepository repository = (IPatternRepository)selection.getFirstElement();
                    CloseCatalogOperation operation = new CloseCatalogOperation((PatternRepository)repository);
                    CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)operation);
                    AbstractPatternPresentationPage.this.getWizard().notifyRepositoryRegistryChanged();
                    repositoryViewer_p.refresh(false);
                    IPatternRepository atSamePosition = (IPatternRepository)repositoryViewer_p.getElementAt(selectionIndex);
                    if (atSamePosition == null) {
                        atSamePosition = (IPatternRepository)repositoryViewer_p.getElementAt(selectionIndex - 1);
                    }
                    StructuredSelection newSelection = atSamePosition == null ? new StructuredSelection() : new StructuredSelection((Object)atSamePosition);
                    repositoryViewer_p.setSelection((ISelection)newSelection);
                }
            }
        });
        return result;
    }

    protected Button createRepositoryNewButton(Composite parent_p, final StructuredViewer repositoryViewer_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractPatternPresentationPage_New);
        result.setLayoutData((Object)new GridData(4, 4, false, false));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Resource resource;
                Object scopeElement = AbstractPatternPresentationPage.this.getData().getScopeElement();
                TransactionalEditingDomain domain = CorePatternsPlugin.getDefault().getModelEnvironment().getCommonCatalogEditingDomain();
                Resource resource2 = resource = scopeElement instanceof EObject ? ((EObject)scopeElement).eResource() : (Resource)scopeElement;
                if (domain != null) {
                    ResourceSet rset = domain.getResourceSet();
                    IFile file = UIUtil.promptForNewCatalogFile(AbstractPatternPresentationPage.this.getShell(), resource, rset);
                    if (file != null) {
                        CreateCatalogOperation operation = new CreateCatalogOperation(file, domain, scopeElement);
                        IPatternRepository created = (IPatternRepository)CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)operation);
                        if (created != null) {
                            repositoryViewer_p.refresh(false);
                            repositoryViewer_p.setSelection((ISelection)new StructuredSelection((Object)created));
                        }
                    }
                }
            }
        });
        return result;
    }

    protected Button createRepositoryOpenButton(Composite parent_p, final StructuredViewer repositoryViewer_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractPatternPresentationPage_Open);
        result.setLayoutData((Object)new GridData(4, 4, false, false));
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Resource resource;
                Object scopeElement = AbstractPatternPresentationPage.this.getData().getScopeElement();
                TransactionalEditingDomain domain = CorePatternsPlugin.getDefault().getModelEnvironment().getCommonCatalogEditingDomain();
                Object object = scopeElement instanceof EObject ? ((EObject)scopeElement).eResource() : (resource = scopeElement instanceof Resource ? (Resource)scopeElement : null);
                if (domain != null) {
                    ResourceSet rset = domain.getResourceSet();
                    List<IFile> files = UIUtil.promptForExistingCatalogs(AbstractPatternPresentationPage.this.getShell(), resource, rset);
                    if (!files.isEmpty()) {
                        Iterator<IFile> it = files.iterator();
                        ArrayList opened = new ArrayList();
                        while (it.hasNext()) {
                            IFile current = it.next();
                            OpenCatalogOperation operation = new OpenCatalogOperation((Object)current, domain);
                            opened.addAll((Collection)CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)operation));
                            if (operation.getErrors().isEmpty()) continue;
                            UIUtil.informRepositoryOpeningError(AbstractPatternPresentationPage.this.getShell(), operation.getErrors());
                            return;
                        }
                        if (!opened.isEmpty()) {
                            AbstractPatternPresentationPage.this.getWizard().notifyRepositoryRegistryChanged();
                            repositoryViewer_p.refresh(false);
                            IPatternRepository toSelect = (IPatternRepository)opened.iterator().next();
                            repositoryViewer_p.setSelection((ISelection)new StructuredSelection((Object)toSelect));
                        }
                    }
                }
            }
        });
        return result;
    }

    protected Button createTemplateButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        result.setText(Messages.AbstractPatternPresentationPage_UseTemplate);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                if (AbstractPatternPresentationPage.this.getData().getPattern() != null && TemplateUsageSpecification.isReadyForTemplateUsage((TemplatePattern)AbstractPatternPresentationPage.this.getData().getPattern())) {
                    int VECTOR = 50;
                    Point location = AbstractPatternPresentationPage.this.getShell().getLocation();
                    Point newLocation = new Point(location.x + 50, location.y + 50);
                    TemplateUsageWizard wizard = new TemplateUsageWizard((AbstractModifiableTemplatePatternSpecification)AbstractPatternPresentationPage.this.getData());
                    PatternWizardDialog dialog = new PatternWizardDialog(AbstractPatternPresentationPage.this.getShell(), wizard, false, newLocation);
                    int answer = dialog.open();
                    if (wizard.repositoryRegistryChanged()) {
                        AbstractPatternPresentationPage.this._repositoryViewer.refresh(false);
                    }
                    if (answer == 0) {
                        AbstractPatternPresentationPage.this.useTemplate((TemplateUsageSpecification)wizard.getData());
                    }
                } else {
                    String message = AbstractPatternPresentationPage.this.getData().getPattern() == null || !AbstractPatternPresentationPage.this.getData().getPattern().isTemplate() ? Messages.AbstractPatternPresentationPage_TemplateApplicability : Messages.AbstractPatternPresentationPage_TemplateApplicabilityOnTemplate;
                    MessageDialog.openError((Shell)AbstractPatternPresentationPage.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)message);
                }
            }
        });
        return result;
    }

    protected Text createVersionRow(Composite parent_p) {
        new Label(parent_p, 0).setText(Messages.AbstractPatternPresentationPage_Version);
        final Text result = new Text(parent_p, 2052);
        if (this.getData().getPattern() != null) {
            result.setText(this.nonNull(this.getData().getPattern().getVersion()));
        }
        this.finishRow(parent_p, true);
        result.setEditable(this._patternIsEditable);
        if (this._patternIsEditable) {
            result.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e_p) {
                    String value = result.getText();
                    AbstractPatternPresentationPage.this.getData().getPattern().setVersion(value);
                    AbstractPatternPresentationPage.this.validate();
                }
            });
        }
        if (this.getData() instanceof ITemplatePatternSelection) {
            ((ITemplatePatternSelection)this.getData()).addSelectedPatternListener(new ITemplatePatternSelection.IPatternChangedListener(){

                public void patternChanged(TemplatePattern newPattern_p) {
                    String newText = newPattern_p == null ? "" : AbstractPatternPresentationPage.this.nonNull(newPattern_p.getVersion());
                    result.setText(newText);
                }
            });
        }
        return result;
    }

    protected void deletePattern() {
        boolean confirmed;
        IPatternSupport support;
        TemplatePattern pattern = this.getData().getPattern();
        final ArrayList<IPatternInstance> instances = new ArrayList<IPatternInstance>();
        Object context = this.getData().getScopeElement();
        if (context instanceof EObject && (support = CorePatternsPlugin.getDefault().getPatternSupportFor((EObject)context)) != null) {
            List allInstances = support.getAllInstances(context);
            for (IPatternInstance instance : allInstances) {
                if (instance.getPattern() != pattern) continue;
                instances.add(instance);
            }
        }
        final boolean instancesDetected = !instances.isEmpty();
        final ArrayList<Object> emptyIfInstancesUntouched = new ArrayList<Object>(1);
        final Object flag = new Object();
        if (instancesDetected) {
            emptyIfInstancesUntouched.add(flag);
        }
        String message = String.format(Messages.AbstractPatternPresentationPage_ConfirmPatternDeletion, pattern.getName());
        MessageDialog confirmationDialog = new MessageDialog(this.getShell(), Messages.AbstractPatternPresentationPage_TitlePatternDeletion, null, message, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected Control createCustomArea(Composite parent_p) {
                Group result = new Group(parent_p, 0);
                result.setText(Messages.AbstractPatternPresentationPage_InstancesDeletionGroup);
                result.setLayout((Layout)new GridLayout(1, true));
                new Label((Composite)result, 0).setText(String.format(Messages.AbstractPatternPresentationPage_DetectedInstances, instances.size()));
                Button checkbox = new Button((Composite)result, 32);
                checkbox.setEnabled(instancesDetected);
                checkbox.setSelection(!emptyIfInstancesUntouched.isEmpty());
                checkbox.setText(Messages.AbstractPatternPresentationPage_DeleteInstancesWithPattern);
                checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (emptyIfInstancesUntouched.isEmpty()) {
                            emptyIfInstancesUntouched.add(flag);
                        } else {
                            emptyIfInstancesUntouched.clear();
                        }
                    }
                });
                return result;
            }
        };
        boolean bl = confirmed = confirmationDialog.open() == 0;
        if (confirmed) {
            DeletePatternOperation operation = new DeletePatternOperation(pattern, instances, (Object)pattern);
            List deleted = (List)CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)operation);
            if (deleted == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AbstractPatternPresentationPage_TitlePatternDeletion, (String)Messages.AbstractPatternPresentationPage_Failure);
            } else if (this.getData() instanceof IRepositorySelection) {
                IRepositorySelection data = (IRepositorySelection)this.getData();
                data.setRepository(data.getRepository());
            }
        }
    }

    protected int getGridColumnsNb() {
        return 4;
    }

    protected String getExistingPatternRowLabel() {
        return Messages.AbstractPatternPresentationPage_Pattern;
    }

    protected void setPatternImageToDefault() {
    }

    protected void useTemplate(TemplateUsageSpecification data_p) {
        final TemplateUsageDialog dialog = new TemplateUsageDialog(this.getShell(), data_p);
        int answer = dialog.open();
        if (answer == 0) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AbstractPatternPresentationPage.this.getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                dialog.getData().execute();
                            }
                        });
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum PatternSelectionKind {
        FIXED,
        NEW,
        SELECTABLE,
        SELECTABLE_WITH_DELETE;

    }
}

