/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.commands;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationItem;
import org.polarsys.capella.core.data.information.datavalue.DataValueContainer;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.transition.system.topdown.commands.IntramodelTransitionCommand;

public class TransitionCommandHelper {
    public static TransitionCommandHelper getInstance() {
        return new TransitionCommandHelper();
    }

    public ICommand getActorTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.actor";
            }
        };
    }

    public ICommand getDataTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.data";
            }
        };
    }

    public ICommand getExchangeItemTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.exchangeitem";
            }
        };
    }

    public ICommand getFunctionalTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.functional";
            }
        };
    }

    public ICommand getOCtoSMTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oc2mission";
            }
        };
    }

    public ICommand getOAtoSCTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oa2capability";
            }
        };
    }

    public ICommand getOAtoSMTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oa2mission";
            }
        };
    }

    public ICommand getInterfaceTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.interface";
            }
        };
    }

    public ICommand getLC2PCTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.lc2pc";
            }
        };
    }

    public ICommand getStateMachineTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.statemachine";
            }
        };
    }

    public ICommand getCapabilityTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.capability";
            }
        };
    }

    public ICommand getOE2SystemTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oe2system";
            }
        };
    }

    public ICommand getOE2ActorTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.oe2actor";
            }
        };
    }

    public ICommand getPropertyValueTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.propertyvalue";
            }
        };
    }

    public ICommand getSystemTransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.system";
            }
        };
    }

    public ICommand getPC2CITransitionCommand(Collection<?> elements, IProgressMonitor monitor) {
        return new IntramodelTransitionCommand(elements, monitor){

            @Override
            protected String getTransitionKind() {
                return "capella.core.transition.system.topdown.pc2ci";
            }
        };
    }

    public boolean isFunctionalTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractFunction || object instanceof FunctionPkg || object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg || object instanceof FunctionalExchange || object instanceof FunctionalChain);
    }

    public boolean isInterfaceTransitionAvailable(EObject object) {
        return !(!(object instanceof Interface) && !(object instanceof InterfacePkg) || !CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)));
    }

    public boolean isExchangeItemTransitionAvailable(EObject object) {
        return !(!(object instanceof CapellaElement) || !CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) || !(object instanceof ExchangeItem) && !(object instanceof ExchangeItemAllocation));
    }

    public boolean isStateMachineTransitionAvailable(EObject object) {
        return (object instanceof BlockArchitecture && this.isSMTransitionAvailableOnBlockArchitecture((BlockArchitecture)object) || object instanceof Component && this.isSMTransitionAvailableOnComponent((Component)object) || object instanceof Part && this.isSMTransitionAvailableOnPart((Part)object) || object instanceof StateMachine || object instanceof AbstractState || object instanceof StateTransition) && object instanceof CapellaElement && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)object));
    }

    private boolean isSMTransitionAvailableOnComponent(Component comp) {
        return !comp.getOwnedStateMachines().isEmpty();
    }

    private boolean isSMTransitionAvailableOnPart(Part part) {
        return part.getAbstractType() instanceof Component && this.isSMTransitionAvailableOnComponent((Component)part.getAbstractType());
    }

    private boolean isSMTransitionAvailableOnBlockArchitecture(BlockArchitecture arch) {
        return arch.getSystem() != null && this.isSMTransitionAvailableOnComponent(arch.getSystem());
    }

    public boolean isDataTransitionAvailable(EObject object) {
        return (object instanceof BlockArchitecture && ((BlockArchitecture)object).getOwnedDataPkg() != null || object instanceof Component && ((Component)object).getOwnedDataPkg() != null || object instanceof Part && ((Part)object).getAbstractType() != null && ((Part)object).getAbstractType() instanceof Component && ((Component)((Part)object).getAbstractType()).getOwnedDataPkg() != null || object instanceof DataPkg || object instanceof DataValueContainer || object instanceof Collection || object instanceof CommunicationItem || object instanceof Class) && object instanceof CapellaElement && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)object)) && !CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)((CapellaElement)object));
    }

    public boolean isFunctionalScenario(Scenario scenario) {
        if (scenario.getKind() == ScenarioKind.FUNCTIONAL) {
            return true;
        }
        if (scenario.getKind() == ScenarioKind.INTERACTION) {
            for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
                if (role.getRepresentedInstance() == null || !(role.getRepresentedInstance() instanceof AbstractFunction)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActorTransitionAvailable(EObject object) {
        Component component;
        ComponentPkg componentPkg;
        if ((object instanceof SystemAnalysis || object instanceof LogicalArchitecture) && (componentPkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)((BlockArchitecture)object))) != null && !ComponentPkgExt.getExternalActors((ComponentPkg)componentPkg).isEmpty()) {
            return true;
        }
        if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) && ((component = this.getComponent(object)) instanceof SystemComponent && ComponentExt.isActor((EObject)object) || object instanceof SystemComponentPkg && !ComponentPkgExt.getAllActors((ComponentPkg)((ComponentPkg)object)).isEmpty() || object instanceof ComponentExchange && ComponentExchangeExt.isLinkToAnActor((ComponentExchange)((ComponentExchange)object)) || object instanceof PhysicalLink)) {
            return true;
        }
        return CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) && ((component = this.getComponent(object)) instanceof LogicalComponent && ComponentExt.isExternalActor((Component)component) || object instanceof LogicalComponentPkg && !ComponentPkgExt.getExternalActors((ComponentPkg)((ComponentPkg)object)).isEmpty() || object instanceof ComponentExchange && ComponentExchangeExt.isLinkToAnActor((ComponentExchange)((ComponentExchange)object)) || object instanceof PhysicalLink);
    }

    public boolean isSystemTransitionAvailable(EObject object) {
        if (object instanceof SystemAnalysis) {
            return true;
        }
        if (object instanceof SystemComponentPkg && object.eContainer() instanceof BlockArchitecture) {
            return true;
        }
        if (object instanceof SystemComponent) {
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)object);
            return object.equals(architecture.getSystem());
        }
        if (object instanceof Part && CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object))) {
            Component component = this.getComponent(object);
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)object);
            return component != null && component.equals(architecture.getSystem());
        }
        return false;
    }

    public boolean isLC2PCTransitionAvailable(EObject object) {
        Component component;
        if (object instanceof LogicalArchitecture) {
            return true;
        }
        return CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object)) && ((component = this.getComponent(object)) instanceof LogicalComponent || object instanceof LogicalComponentPkg || object instanceof ComponentExchange && ComponentExchangeExt.isNotLinkToAnActor((ComponentExchange)((ComponentExchange)object)));
    }

    public boolean isOE2ActorTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof Entity || object instanceof EntityPkg || object instanceof CommunicationMean);
    }

    public boolean isOE2SystemTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof Entity && !((Entity)object).isHuman() || object instanceof EntityPkg || object instanceof CommunicationMean);
    }

    public boolean isOA2SCTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof OperationalActivity || object instanceof OperationalActivityPkg);
    }

    public boolean isOA2SMTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof OperationalActivity || object instanceof OperationalActivityPkg);
    }

    public boolean isCapabilityTransitionAvailable(EObject object) {
        return object instanceof SystemAnalysis || object instanceof LogicalArchitecture || object instanceof OperationalAnalysis || object instanceof CapellaElement && (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)object)) || CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)object))) && (object instanceof AbstractCapability || object instanceof AbstractCapabilityPkg);
    }

    public boolean isOC2SMTransitionAvailable(EObject object) {
        return object instanceof OperationalAnalysis || object instanceof CapellaElement && CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)((CapellaElement)object)) && (object instanceof OperationalCapability || object instanceof OperationalCapabilityPkg);
    }

    private Component getComponent(EObject object) {
        if (object != null) {
            Part part;
            AbstractType abstractType;
            if (object instanceof Component) {
                return (Component)object;
            }
            if (object instanceof Part && (abstractType = (part = (Part)object).getAbstractType()) != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        }
        return null;
    }

    public boolean isPropertyValueTransitionAvailable(EObject element) {
        return element instanceof CapellaElement && (element instanceof PropertyValueGroup || element instanceof PropertyValuePkg || element instanceof AbstractPropertyValue || element instanceof EnumerationPropertyType) && EcoreUtil2.isContainedBy((EObject)element, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE) && !CapellaLayerCheckingExt.isAOrInEPBSLayer((CapellaElement)((CapellaElement)element));
    }

    public boolean isPC2CITransitionAvailable(EObject element) {
        Component component;
        return CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)((CapellaElement)element)) && ((component = this.getComponent(element)) instanceof PhysicalComponent || element instanceof PhysicalComponentPkg || element instanceof ComponentExchange && ComponentExchangeExt.isNotLinkToAnActor((ComponentExchange)((ComponentExchange)element)));
    }
}

