/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.internal.session.SessionSaveable;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaSaveablesProvider
extends SaveablesProvider
implements SessionManagerListener {
    private Map<Session, Saveable> _saveables = new HashMap<Session, Saveable>(0);

    protected void doInit() {
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
        for (Session activeSession : SessionManager.INSTANCE.getSessions()) {
            this.notifyAddSession(activeSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
        Map<Session, Saveable> map = this._saveables;
        synchronized (map) {
            this._saveables.clear();
        }
        super.dispose();
    }

    public Object[] getElements(Saveable saveable) {
        Object[] result = new Object[]{saveable.getAdapter(Session.class)};
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Saveable getSaveable(Object element) {
        Saveable result = null;
        if (element instanceof IFile && ((IFile)element).getFileExtension().equals("aird")) {
            Map<Session, Saveable> map = this._saveables;
            synchronized (map) {
                result = this._saveables.get(SessionHelper.getSession((IFile)((IFile)element)));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Saveable[] getSaveables() {
        Saveable[] result = null;
        Map<Session, Saveable> map = this._saveables;
        synchronized (map) {
            Collection<Saveable> saveables = this._saveables.values();
            result = saveables.toArray(new Saveable[saveables.size()]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyAddSession(Session newSession) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(newSession);
        if (!(uiSession instanceof ISaveablesSource)) throw new ClassCastException(String.format(Messages.CapellaSaveablesProvider_IEditingSessionRetrieval_ShouldAlsoImplementISaveablesSource, IEditingSession.class.getSimpleName(), ISaveablesSource.class.getSimpleName()));
        ISaveablesSource saveablesProvider = (ISaveablesSource)uiSession;
        Saveable[] saveables = saveablesProvider.getSaveables();
        if (saveables.length != 1) throw new IllegalArgumentException(String.format(Messages.CapellaSaveablesProvider_IEditingSessionRetrieval_WrongNumberOfSaveables, ISaveablesSource.class.getSimpleName(), uiSession.getClass().getSimpleName(), Saveable.class.getSimpleName(), this._saveables.size()));
        Map<Session, Saveable> map = this._saveables;
        synchronized (map) {
            this._saveables.put(newSession, saveables[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoveSession(Session removedSession) {
        Map<Session, Saveable> map = this._saveables;
        synchronized (map) {
            this._saveables.remove(removedSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Session updatedSession, int notification) {
        final Saveable[] saveable = new Saveable[1];
        Map<Session, Saveable> map = this._saveables;
        synchronized (map) {
            saveable[0] = this._saveables.get(updatedSession);
        }
        if (saveable[0] == null) {
            return;
        }
        Runnable runnable = null;
        switch (notification) {
            case 2: 
            case 3: {
                runnable = new Runnable(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        void ss;
                        void var2_1;
                        SessionSaveable sessionSaveable;
                        Saveable saveable2;
                        if (saveable[0] != null && (saveable2 = saveable[0]) instanceof SessionSaveable && (sessionSaveable = (SessionSaveable)saveable2) == (SessionSaveable)var2_1 && ss.getSession() != null && ss.getSession().isOpen()) {
                            try {
                                CapellaSaveablesProvider.this.fireSaveablesDirtyChanged(new Saveable[]{saveable[0]});
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                };
                break;
            }
            case 9: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (saveable[0] != null) {
                            try {
                                CapellaSaveablesProvider.this.fireSaveablesClosed(new Saveable[]{saveable[0]});
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                };
                break;
            }
            case 8: {
                runnable = new Runnable(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        void ss;
                        void var2_1;
                        SessionSaveable sessionSaveable;
                        Saveable saveable2;
                        if (saveable[0] != null && (saveable2 = saveable[0]) instanceof SessionSaveable && (sessionSaveable = (SessionSaveable)saveable2) == (SessionSaveable)var2_1 && ss.getSession() != null && ss.getSession().isOpen()) {
                            try {
                                CapellaSaveablesProvider.this.fireSaveablesClosing(new Saveable[]{saveable[0]}, false);
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                };
                break;
            }
            case 7: {
                runnable = new Runnable(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        void ss;
                        void var2_1;
                        SessionSaveable sessionSaveable;
                        Saveable saveable2;
                        if (saveable[0] != null && (saveable2 = saveable[0]) instanceof SessionSaveable && (sessionSaveable = (SessionSaveable)saveable2) == (SessionSaveable)var2_1 && ss.getSession() != null && ss.getSession().isOpen()) {
                            try {
                                CapellaSaveablesProvider.this.fireSaveablesOpened(new Saveable[]{saveable[0]});
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    }
                };
            }
        }
        if (runnable != null) {
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
            }
        }
    }

    public void notifyUpdatedSession(Session updated) {
    }

    public void viewpointDeselected(Viewpoint deselectedViewpoint) {
    }

    public void viewpointSelected(Viewpoint selectedViewpoint) {
    }
}

