/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public abstract class AbstractSelectOneResolver
extends AbstractCapellaMarkerResolution {
    protected abstract boolean isAvailableFor(EObject var1);

    public void run(IMarker marker) {
        List modelElements = this.getModelElements(marker);
        if (!modelElements.isEmpty() && this.isAvailableFor((EObject)modelElements.get(0))) {
            this.openSelectionDialog((EObject)modelElements.get(0), marker);
        }
    }

    protected abstract void openSelectionDialog(EObject var1, IMarker var2);

    protected void confirmDeletion(IMarker marker, EObject semantic, List<? extends EObject> toBeDeleted) {
        CapellaDeleteCommand command;
        boolean confirmDeletion = CapellaDeleteCommand.confirmDeletion((ExecutionManager)TransactionHelper.getExecutionManager((EObject)semantic), toBeDeleted);
        if (confirmDeletion && (command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager((EObject)semantic), toBeDeleted, false, false, true)).canExecute()) {
            command.execute();
            this.deleteMarker(marker);
        }
    }

    protected void deleteMarker(IMarker marker) {
        try {
            marker.delete();
        }
        catch (CoreException exception) {
            StatusManager.getManager().handle((IStatus)new Status(4, PluginActivator.getDefault().getPluginId(), exception.getMessage(), (Throwable)exception));
        }
    }
}

