/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.TransactionHelper;

public class AbstractCommandActionHandler
extends BaseSelectionListenerAction {
    protected WeakReference<Command> command;

    public AbstractCommandActionHandler(String text_p) {
        super(text_p);
    }

    protected void setCommand(Command command_p) {
        this.command = new WeakReference<Command>(command_p);
    }

    public void run() {
        EditingDomain editingDomain = this.getEditingDomain(this.getStructuredSelection());
        if (editingDomain != null) {
            editingDomain.getCommandStack().execute(this.getCommand());
        }
    }

    protected EditingDomain getEditingDomain(IStructuredSelection selection_p) {
        if (selection_p != null) {
            Collection<EObject> collection = this.filterSelection(selection_p.toList());
            return TransactionHelper.getEditingDomain(collection);
        }
        return null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Command c;
        if (this.command != null) {
            this.command = null;
        }
        return (c = this.getCommand()) != null && c.canExecute();
    }

    protected Collection<EObject> filterSelection(Collection<Object> list_p) {
        ArrayList<EObject> temporarySelection = new ArrayList<EObject>((List)list_p);
        Iterator iterator = temporarySelection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof EObject) continue;
            iterator.remove();
        }
        return temporarySelection;
    }

    protected Command getCommand() {
        Command result = null;
        if (this.command != null) {
            result = (Command)this.command.get();
        }
        if (result == null) {
            Collection<EObject> collection = this.filterSelection(this.getStructuredSelection().toList());
            result = this.createCommand(collection);
            this.setCommand(result);
        }
        return result;
    }

    protected Command createUnexecutableCommand() {
        return UnexecutableCommand.INSTANCE;
    }

    public Command createCommand(Collection<Object> selection) {
        return this.createUnexecutableCommand();
    }
}

