/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalChain;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.validation.functionalChain.Messages;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_FunctionalChain_Involvements_1
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getEventType() == EMFEventType.NULL && ctx.getTarget() instanceof FunctionalChain) {
            FunctionalChain chain = (FunctionalChain)ctx.getTarget();
            EList ownedFunctionalChainInvolvements = chain.getOwnedFunctionalChainInvolvements();
            if (ownedFunctionalChainInvolvements.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_IsEmpty});
            }
            StringBuilder invalidInvolvementsMessage = new StringBuilder();
            int invalidInvolvementsSize = 0;
            for (FunctionalChainInvolvement involvement : ownedFunctionalChainInvolvements) {
                IStatus status = FunctionalChainExt.getFunctionalChainInvolvementValidityStatus((FunctionalChainInvolvement)involvement);
                if (status.isOK()) continue;
                invalidInvolvementsMessage.append(EObjectLabelProviderHelper.getText((Object)involvement));
                invalidInvolvementsMessage.append(' ');
                invalidInvolvementsMessage.append('(');
                invalidInvolvementsMessage.append(status.getMessage());
                invalidInvolvementsMessage.append(')');
                invalidInvolvementsMessage.append('\n');
                ++invalidInvolvementsSize;
            }
            if (invalidInvolvementsSize > 0) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), NLS.bind((String)Messages.MDCHK_FunctionalChain_Involvements_1_InvolvementInvalid, (Object)String.valueOf(invalidInvolvementsSize), (Object)invalidInvolvementsMessage.toString())});
            }
            if (!FunctionalChainExt.isFunctionalChainWellFormed((FunctionalChain)chain)) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_NotWellFormed});
            }
            if (FunctionalChainExt.containsACycle((FunctionalChain)chain)) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_FunctionalChain_Involvements_1_ContainsACycle});
            }
        }
        return ctx.createSuccessStatus();
    }
}

