/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IRestraintProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.BrowseRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.DefaultLabelProvider;
import org.polarsys.capella.common.ui.toolkit.dialogs.SelectElementsDialog;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class SharedElementsRenderer
extends BrowseRenderer {
    ILabelProvider provider = null;

    protected Color getDefaultColor(Display display) {
        return display.getSystemColor(22);
    }

    protected String getBrowseText() {
        return "Browse external elements";
    }

    protected void proceedBrowse(Shell shell, IRendererContext context) {
        IContext ctx = (IContext)context.getPropertyContext().getSource();
        if (ctx.exists((Object)"COMMAND__CURRENT_VALUE")) {
            String value = (String)ctx.get((Object)"COMMAND__CURRENT_VALUE");
            if ("COMMAND__CREATE_REPLICABLE_ELEMENT".equals(value) || "COMMAND__UPDATE_CURRENT_REPLICA_FROM_REPLICA".equals(value) || "COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value)) {
                IPropertyContext propertyContext = context.getPropertyContext();
                Collection current = (Collection)propertyContext.getCurrentValue(context.getProperty((IPropertyRenderer)this));
                HashSet scope = new HashSet();
                scope.addAll(current);
                scope.remove(null);
                SelectElementsDialog dialog = new SelectElementsDialog(shell, "External elements", "External elements referenced", new ArrayList(scope));
                dialog.open();
            } else {
                super.proceedBrowse(shell, context);
            }
        }
    }

    public void updatedValue(IProperty property, IRendererContext rendererContext, Object newValue) {
        super.updatedValue(property, rendererContext, newValue);
        if (!this.isDisposed()) {
            boolean value;
            IStatus diag = property.validate(rendererContext.getPropertyContext().getCurrentValue(property), rendererContext.getPropertyContext());
            boolean bl = value = !diag.isOK();
            if (property instanceof IRestraintProperty) {
                value = value || !((IRestraintProperty)property).getChoiceValues(rendererContext.getPropertyContext()).isEmpty();
            }
            this.setBrowseEnabled(value);
        }
    }

    protected boolean isValidationEnd() {
        return false;
    }

    protected int getRootStyle() {
        return 0;
    }

    protected boolean isDescription() {
        return false;
    }

    protected boolean isEditable(IProperty property, IRendererContext context) {
        return false;
    }

    protected boolean isImage() {
        return false;
    }

    protected ILabelProvider getLabelProvider(final IRendererContext context) {
        if (this.provider == null) {
            this.provider = new DefaultLabelProvider(super.getLabelProvider(context)){

                public String getText(Object object) {
                    IProperty property = context.getProperty((IPropertyRenderer)SharedElementsRenderer.this);
                    IStatus valid = property.validate(context.getPropertyContext().getCurrentValue(property), context.getPropertyContext());
                    if (valid != null && !valid.isOK()) {
                        return valid.getMessage();
                    }
                    return "";
                }
            };
        }
        return this.provider;
    }
}

