/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.ui.handlers.AbstractDiagramCommandHandler;

public class CreateFunctionalChainActionHandler
extends AbstractDiagramCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection();
        ArrayList<AbstractGraphicalEditPart> edgeEditParts = new ArrayList<AbstractGraphicalEditPart>();
        for (Object elem : selection.toList()) {
            if (!(elem instanceof AbstractGraphicalEditPart)) continue;
            edgeEditParts.add((AbstractGraphicalEditPart)elem);
        }
        if (!edgeEditParts.isEmpty()) {
            List<EObject> diagramElements = edgeEditParts.stream().map(edgeEditPart -> edgeEditPart.getModel()).map(View.class::cast).map(model -> model.getElement()).collect(Collectors.toList());
            EObject context = ((DDiagramElement)diagramElements.get(0)).getTarget();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)((AbstractGraphicalEditPart)edgeEditParts.get(0)).getModel());
            AbstractReadWriteCommandWithResult customCommand = new AbstractReadWriteCommandWithResult(diagram, context, diagramElements);
            ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)TransactionUtil.getEditingDomain((EObject)context)).execute((ICommand)customCommand);
            DNode result = customCommand.getResult();
            return result;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private class AbstractReadWriteCommandWithResult
    extends AbstractReadWriteCommand {
        DNode result = null;
        EObject context = null;
        List<EObject> diagramElements = new ArrayList<EObject>();
        DDiagram diagram = null;

        public AbstractReadWriteCommandWithResult(DDiagram diagram, EObject context, List<EObject> diagramElements) {
            this.context = context;
            this.diagramElements = diagramElements;
            this.diagram = diagram;
        }

        public DNode getResult() {
            return this.result;
        }

        public void run() {
            EObject fc = FunctionalChainServices.getFunctionalChainServices().createFunctionalChain(this.context, this.diagramElements);
            String mappingName = MappingConstantsHelper.getMappingFunctionalChainEnd((DDiagram)this.diagram);
            NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(this.diagram, mappingName);
            this.result = DiagramServices.getDiagramServices().createNode(mapping, fc, (DragAndDropTarget)this.diagram, this.diagram);
            DialectManager.INSTANCE.refresh((DRepresentation)this.diagram, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

