/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.communication;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.helpers.information.services.LinkCompatibilityDefinition;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class CommunicationLinkkindRule
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CommunicationLink) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            CommunicationLink link = (CommunicationLink)eObj;
            CommunicationLinkKind kind = link.getKind();
            ExchangeItem exchangeItem = link.getExchangeItem();
            if (exchangeItem != null && exchangeItem instanceof ExchangeItem) {
                ExchangeMechanism defaultMechanism;
                ExchangeItem item = exchangeItem;
                ExchangeMechanism exchangeMechanism = item.getExchangeMechanism();
                if (kind != null && !LinkCompatibilityDefinition.INSTANCE.isDefaultKind(kind) && exchangeMechanism != (defaultMechanism = LinkCompatibilityDefinition.INSTANCE.getMechanism(kind))) {
                    IStatus status = ctx.createFailureStatus(new Object[]{link, kind, defaultMechanism, item, exchangeMechanism});
                    statuses.add(status);
                }
                if (statuses.size() > 0) {
                    return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

