/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.dialog;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.diagram.helpers.RepresentationAnnotationHelper;

public class ProgressMonitoringLabelProvider
extends MDEAdapterFactoryLabelProvider
implements IColorProvider {
    private int _foregroundColor;
    private TreeViewer _viewer;

    public ProgressMonitoringLabelProvider(TreeViewer viewer, int foregroundColorForReferencingElements) {
        this._foregroundColor = foregroundColorForReferencingElements;
        this._viewer = viewer;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        Object input = this._viewer.getInput();
        if (input instanceof TreeData && ((TreeData)input).isValid(element)) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            return display.getSystemColor(this._foregroundColor);
        }
        return null;
    }

    public String getText(Object object) {
        String text = super.getText(object);
        return text.replace("%20", " ");
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        if (columnIndex == 0) {
            text = this.getText(element);
        } else if (1 == columnIndex) {
            DRepresentationDescriptor representationDesc;
            EnumerationPropertyLiteral status;
            EnumerationPropertyLiteral status2;
            if (element instanceof CapellaElement && (status2 = ((CapellaElement)element).getStatus()) != null) {
                text = status2.getLabel();
            }
            if (element instanceof DRepresentationDescriptor && (status = RepresentationAnnotationHelper.getProgressStatus((DRepresentationDescriptor)(representationDesc = (DRepresentationDescriptor)element))) != null) {
                text = status.getLabel();
            }
        } else if (2 == columnIndex) {
            DRepresentationDescriptor representationDesc;
            String review;
            String review2;
            if (element instanceof CapellaElement && (review2 = ((CapellaElement)element).getReview()) != null) {
                text = review2;
            }
            if (element instanceof DRepresentationDescriptor && (review = RepresentationAnnotationHelper.getStatusReview((DRepresentationDescriptor)(representationDesc = (DRepresentationDescriptor)element))) != null) {
                text = review;
            }
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.getImage(element);
        }
        return image;
    }
}

