/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.Messages;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyWizardPage;

public class PropertyWizard
extends Wizard {
    protected IPropertyContext _context;
    protected IRendererContext _renderers;
    private boolean messageOnWarning = false;

    public boolean isMessageOnWarning() {
        return this.messageOnWarning;
    }

    public void setMessageOnWarning(boolean messageOnWarning) {
        this.messageOnWarning = messageOnWarning;
    }

    protected IRendererContext getRendererContext() {
        return this._renderers;
    }

    protected IPropertyContext getContext() {
        return this._context;
    }

    public boolean needsProgressMonitor() {
        return super.needsProgressMonitor();
    }

    public PropertyWizard(IPropertyContext context, IRendererContext renderers) {
        this._context = context;
        this._renderers = renderers;
        this.setNeedsProgressMonitor(false);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void addPages() {
        PropertyWizardPage page = new PropertyWizardPage("propertiesEditor", this.getContext(), this.getRendererContext());
        this.addPage((IWizardPage)page);
    }

    public boolean performFinish() {
        if (this.isValid()) {
            IPropertyContext context = this.getContext();
            if (context != null) {
                context.writeAll();
            }
            return true;
        }
        return false;
    }

    protected boolean isValid() {
        IWizardPage page;
        if (this.isMessageOnWarning() && (page = this.getContainer().getCurrentPage()) instanceof IMessageProvider) {
            String message = NLS.bind((String)Messages.PropertyWizard_Confirm, (Object)((IMessageProvider)page).getMessage());
            int messageType = ((IMessageProvider)page).getMessageType();
            if (2 == messageType) {
                MessageDialog dialog = new MessageDialog(this.getShell(), this.getContainer().getCurrentPage().getTitle(), null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                return dialog.open() == 0;
            }
        }
        return true;
    }
}

