/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;
import org.polarsys.capella.common.ui.toolkit.browser.action.BrowserActionFactory;
import org.polarsys.capella.common.ui.toolkit.browser.view.ISemanticBrowserViewPart;
import org.polarsys.capella.core.ui.semantic.browser.actions.LexicographicSortTreeAction;
import org.polarsys.capella.core.ui.semantic.browser.actions.LimitateTreeExpansionAction;
import org.polarsys.capella.core.ui.semantic.browser.actions.ListenToSelectionEventsAction;
import org.polarsys.capella.core.ui.semantic.browser.actions.RefreshAction;
import org.polarsys.capella.core.ui.semantic.browser.actions.ShowDiagramsAction;

public class SemanticBrowserActionFactory {
    public void createBackAction(ISemanticBrowserViewPart semanticBrowserViewPart) {
        IViewSite viewSite = semanticBrowserViewPart.getViewSite();
        ActionFactory.IWorkbenchAction backAction = BrowserActionFactory.BACKWARD_HISTORY.create(viewSite.getWorkbenchWindow(), semanticBrowserViewPart);
        backAction.setActionDefinitionId("org.polarsys.capella.core.ui.semantic.browser.backwardNavigation");
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)backAction);
    }

    public void createForwardAction(ISemanticBrowserViewPart semanticBrowserViewPart) {
        IViewSite viewSite = semanticBrowserViewPart.getViewSite();
        ActionFactory.IWorkbenchAction forwardAction = BrowserActionFactory.FORWARD_HISTORY.create(viewSite.getWorkbenchWindow(), semanticBrowserViewPart);
        forwardAction.setActionDefinitionId("org.polarsys.capella.core.ui.semantic.browser.forwardNavigation");
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)forwardAction);
    }

    public void createShowDiagramsAction(ISemanticBrowserViewPart semanticBrowserViewPart) {
        ShowDiagramsAction showDiagramsAction = new ShowDiagramsAction(semanticBrowserViewPart);
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)showDiagramsAction);
    }

    public void createLimitateTreeExpansionAction(ISemanticBrowserViewPart semanticBrowserViewPart) {
        LimitateTreeExpansionAction limitateTreeExpansionAction = new LimitateTreeExpansionAction(semanticBrowserViewPart);
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)limitateTreeExpansionAction);
    }

    public void createLexicographicSortTreeAction(ISemanticBrowserViewPart semanticBrowserViewPart) {
        LexicographicSortTreeAction lexicographicSortTreeAction = new LexicographicSortTreeAction(semanticBrowserViewPart);
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)lexicographicSortTreeAction);
    }

    public void createRefreshAction(ISemanticBrowserViewPart semanticBrowserViewPart) {
        RefreshAction refreshAction = new RefreshAction(semanticBrowserViewPart);
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)refreshAction);
    }

    public void createListenToSelectionEventsAction(ISemanticBrowserViewPart semanticBrowserViewPart, boolean isCheced) {
        ListenToSelectionEventsAction listenToSelectionEventsAction = new ListenToSelectionEventsAction(semanticBrowserViewPart, isCheced);
        this.getToolBarManager(semanticBrowserViewPart).add((IAction)listenToSelectionEventsAction);
    }

    private IToolBarManager getToolBarManager(ISemanticBrowserViewPart semanticBrowserViewPart) {
        IViewSite viewSite = semanticBrowserViewPart.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        return actionBars.getToolBarManager();
    }
}

