/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.egf.reporter;

import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.egf.common.generator.EGFJMerger;
import org.eclipse.egf.emf.pattern.base.CodegenGeneratorAdapter;
import org.eclipse.egf.emf.pattern.base.StringJETEmitter;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

public class ExtensionCodegenGeneratorAdapter
extends CodegenGeneratorAdapter {
    public ExtensionCodegenGeneratorAdapter(GenBase generatingObject) {
        super(generatingObject);
    }

    public void generateJava(String targetPath, String packageName, String className, String output) {
        this.generateJava(targetPath, packageName, className, (JETEmitter)new StringJETEmitter(output), null, (Monitor)new BasicMonitor());
    }

    protected void generateJava(String targetPath, String packageName, String className, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        block26: {
            try {
                try {
                    boolean redirect;
                    monitor.beginTask("", 4);
                    URI targetDirectory = this.toURI(targetPath).appendSegments(packageName.split("\\."));
                    URI targetFile = targetDirectory.appendSegment(String.valueOf(className) + ".java");
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{targetFile}));
                    this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                    if (arguments == null) {
                        arguments = new Object[]{this.generatingObject};
                    }
                    this.createImportManager(packageName, className);
                    this.setLineDelimiter(this.getLineDelimiter(targetFile, this.getEncoding(targetFile)));
                    String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter());
                    boolean changed = true;
                    String newContents = emitterResult;
                    boolean targetExists = this.exists(targetFile);
                    JControlModel jControlModel = this.getGenerator().getJControlModel();
                    boolean mergeSuccessful = jControlModel.canMerge();
                    if (mergeSuccessful) {
                        EGFJMerger jMerger = new EGFJMerger(jControlModel);
                        jMerger.setFixInterfaceBrace(jControlModel.getFacadeHelper().fixInterfaceBrace());
                        try {
                            jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
                        }
                        catch (RuntimeException runtimeException) {
                            if (targetExists) {
                                throw runtimeException;
                            }
                            mergeSuccessful = false;
                        }
                        if (mergeSuccessful) {
                            Object codeFormatter;
                            Object object = codeFormatter = this.getGenerator().getOptions().codeFormatting ? this.createCodeFormatter(this.getGenerator().getOptions().codeFormatterOptions, targetFile) : null;
                            if (targetExists) {
                                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), this.getEncoding(targetFile)));
                                String oldContents = jMerger.getTargetCompilationUnitContents();
                                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                                jMerger.merge();
                                newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                                boolean bl = changed = !oldContents.equals(newContents);
                                if (changed && this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), this.getEncoding(targetFile)));
                                    jMerger.remerge();
                                    newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                                }
                            } else {
                                changed = true;
                                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                                jMerger.merge();
                                newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                            }
                            if (jControlModel.getFacadeHelper() != null) {
                                jControlModel.getFacadeHelper().reset();
                            }
                        }
                    }
                    if (!mergeSuccessful) {
                        newContents = CodeGenUtil.convertFormat((String)jControlModel.getLeadingTabReplacement(), (boolean)jControlModel.convertToStandardBraceStyle(), (String)emitterResult);
                        if (targetExists) {
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                            String oldContents = this.getContents(targetFile, null);
                            changed = !oldContents.equals(newContents);
                        } else {
                            changed = true;
                        }
                    }
                    monitor.worked(1);
                    if (!changed) break block26;
                    String encoding = this.getEncoding(targetFile);
                    byte[] bytes = encoding == null ? newContents.getBytes() : newContents.getBytes(encoding);
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, String.valueOf(className) + ".java");
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + className + ".java.new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    try (OutputStream outputStream = null;){
                        outputStream = this.createOutputStream(targetFile);
                        outputStream.write(bytes);
                    }
                }
                catch (Exception e) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new WrappedException(e);
                }
            }
            finally {
                this.clearImportManager();
                this.setLineDelimiter(null);
                monitor.done();
            }
        }
    }
}

