/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.views.libraryManager.accessPolicyManager;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.accessPolicyManager.AccessPolicyManagerWidget;

public final class AccessPolicyEditingSupport
extends EditingSupport {
    private ComboBoxViewerCellEditor cellEditor = null;
    private ColumnViewer columnViewer;
    private LibraryManagerModel model;
    private AccessPolicyManagerWidget widget;

    public AccessPolicyEditingSupport(ColumnViewer viewer, LibraryManagerModel model_p, AccessPolicyManagerWidget widget_p) {
        super(viewer);
        this.model = model_p;
        this.columnViewer = viewer;
        this.widget = widget_p;
        this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
        this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cellEditor.setContenProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.cellEditor.setInput((Object)AccessPolicy.values());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.model.isAccessPolicyModifiable((IModel)element);
    }

    protected Object getValue(Object element) {
        if (element instanceof IModel) {
            IModel library = (IModel)element;
            return this.model.getAccessPolicy(library).getLiteral();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof IModel && value instanceof AccessPolicy) {
            IModel library = (IModel)element;
            AccessPolicy newValue = (AccessPolicy)value;
            if (!this.model.getAccessPolicy(library).equals((Object)newValue)) {
                this.model.setAccessPolicy(library, newValue);
                this.columnViewer.update(element, null);
                this.widget.notifyValueModification();
            }
        }
    }
}

