/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.activities;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.core.transition.common.ExtensionHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.attachment.DefaultAttachmentHandler;
import org.polarsys.capella.core.transition.common.handlers.contextscope.DefaultContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.notify.DefaultNotifyHandler;
import org.polarsys.capella.core.transition.common.handlers.options.DefaultOptionsHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.CompoundScopeFilter;
import org.polarsys.capella.core.transition.common.handlers.scope.CompoundScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.DefaultScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeFilter;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.RuleRelatedElementsScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.selection.CompoundSelectionContextHandler;
import org.polarsys.capella.core.transition.common.handlers.selection.DefaultSelectionContextsHandler;
import org.polarsys.capella.core.transition.common.handlers.selection.TransformationSelectionContext;
import org.polarsys.capella.core.transition.common.handlers.session.DefaultSessionHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.transformation.DefaultTransformationHandler;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class InitializeTransitionActivity
extends AbstractActivity
implements ITransposerWorkflow {
    public static final String ID = "org.polarsys.capella.core.transition.common.activities.InitializeTransitionActivity";
    public static final String PARAMETER_RULE_HANDLER = "org.polarsys.capella.core.transition.ruleHandler";

    @Override
    public String getActivityIdentifier() {
        return "initializeTransition";
    }

    @Override
    public IStatus _run(ActivityParameters activityParams) {
        IStatus status = Status.OK_STATUS;
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        status = this.initializeContext(context, activityParams);
        return status;
    }

    protected IStatus initializeContext(IContext context, ActivityParameters activityParams) {
        IStatus status = Status.OK_STATUS;
        context.put((Object)"TRANSPOSER_APPLY_REQUIRED", (Object)Boolean.TRUE);
        context.put((Object)"TRANSFORMED_ELEMENTS", new HashSet());
        context.put((Object)"TRANSITION_SELECTION", context.get((Object)"TRANSPOSER_SELECTION"));
        status = this.initializeTransitionSources(context, activityParams);
        IRulesHandler ruleHandler = (IRulesHandler)activityParams.getParameter(PARAMETER_RULE_HANDLER).getValue();
        context.put((Object)"_R_H", (Object)ruleHandler);
        status = this.initializeSource(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"_TSRo", "_T_S_Res", "TRANSITION_SOURCE_EDITING_DOMAIN"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeNotifyHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"NOTIFY_HANDLER"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeOptionsHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"_O__H"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.configureLogHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeAttachmentHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"ATTACHMENT_HANDLER"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeContextScopeHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"C_S_H"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeScopeHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"SCOPE_HANDLER"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeSessionHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"_S_H"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeTransformationHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"TrH"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeTraceabilityTargetHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"TTaH"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeSelectionContextsHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"S_C_H"});
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeTarget(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.checkParameters(context, new String[]{"_TTRo", "_T_T_Res", "TRANSITION_TARGET_EDITING_DOMAIN"});
        if (!this.checkStatus(status)) {
            return status;
        }
        return Status.OK_STATUS;
    }

    protected IStatus configureLogHandler(IContext context, ActivityParameters activityParams) {
        LogHelper.getInstance().setLevel(Level.DEBUG);
        return Status.OK_STATUS;
    }

    protected IStatus initializeTransitionSources(IContext context, ActivityParameters activityParams) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SELECTION");
        context.put((Object)"TRANSITION_SOURCES", (Object)selection);
        return Status.OK_STATUS;
    }

    protected IStatus initializeTraceabilityTargetHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("TTaH", activityParams);
        if (handler == null) {
            handler = this.createDefaultTraceabilityTargetHandler();
        }
        context.put((Object)"TTaH", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultTraceabilityTargetHandler() {
        return ITraceabilityHandler.DEFAULT;
    }

    protected IStatus initializeSource(IContext context, ActivityParameters activityParams) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (!selection.isEmpty()) {
            Object source = selection.toArray()[0];
            if (source instanceof EObject) {
                EObject element = (EObject)source;
                Resource resource = element.eResource();
                context.put((Object)"_TSRo", (Object)EcoreUtil.getRootContainer((EObject)element));
                context.put((Object)"_T_S_Res", (Object)resource);
                context.put((Object)"TRANSITION_SOURCE_EDITING_DOMAIN", (Object)TransactionUtil.getEditingDomain((Resource)resource));
            }
        } else {
            return new Status(4, Messages.Activity_Transition, "No input selection");
        }
        return Status.OK_STATUS;
    }

    protected abstract IStatus initializeTarget(IContext var1, ActivityParameters var2);

    protected IStatus initializeNotifyHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("NOTIFY_HANDLER", activityParams);
        if (handler == null) {
            handler = this.createDefaultNotifyHandler();
        }
        IStatus status = handler.init(context);
        context.put((Object)"NOTIFY_HANDLER", (Object)handler);
        return status;
    }

    protected IHandler createDefaultNotifyHandler() {
        return new DefaultNotifyHandler();
    }

    protected IStatus initializeOptionsHandler(IContext context, ActivityParameters activityParams) {
        String optionScope;
        IHandler handler = this.loadHandlerFromParameters("_O__H", activityParams);
        if (handler == null) {
            handler = this.createDefaultOptionsHandler();
        }
        if ((optionScope = this.loadStringFromParameters("_OS", activityParams)) == null) {
            optionScope = this.getDefaultOptionsScope();
        }
        context.put((Object)"OPTIONS_PARAMETERS", (Object)activityParams);
        context.put((Object)"_OS", (Object)optionScope);
        context.put((Object)"_O__H", (Object)handler);
        IStatus status = handler.init(context);
        return status;
    }

    protected IHandler createDefaultOptionsHandler() {
        return new DefaultOptionsHandler();
    }

    protected String getDefaultOptionsScope() {
        return "capella.core.transition";
    }

    protected IStatus initializeAttachmentHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("ATTACHMENT_HANDLER", activityParams);
        if (handler == null) {
            handler = this.createDefaultAttachmentHandler();
        }
        context.put((Object)"ATTACHMENT_HANDLER", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultAttachmentHandler() {
        return new DefaultAttachmentHandler();
    }

    protected IStatus initializeSelectionContextsHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("S_C_H", activityParams);
        if (handler == null) {
            handler = this.createDefaultSelectionContextsHandler();
        }
        if (handler instanceof CompoundSelectionContextHandler) {
            this.initializeSelectionContextHandlers(context, (CompoundSelectionContextHandler)((Object)handler), activityParams);
        }
        context.put((Object)"S_C_H", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected void initializeSelectionContextHandlers(IContext context, CompoundSelectionContextHandler handler, ActivityParameters activityParams) {
        handler.addSelectionContext(context, "SC__T", new TransformationSelectionContext());
    }

    protected IHandler createDefaultSelectionContextsHandler() {
        return new DefaultSelectionContextsHandler();
    }

    protected IStatus initializeScopeHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("SCOPE_HANDLER", activityParams);
        if (handler == null) {
            handler = this.createDefaultScopeHandler();
        }
        if (handler instanceof CompoundScopeFilter) {
            this.initializeScopeFilterHandlers(context, (CompoundScopeFilter)((Object)handler), activityParams);
        }
        if (handler instanceof CompoundScopeRetriever) {
            this.initializeScopeRetrieverHandlers(context, (CompoundScopeRetriever)((Object)handler), activityParams);
        }
        context.put((Object)"SCOPE_HANDLER", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IStatus initializeContextScopeHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("C_S_H", activityParams);
        if (handler == null) {
            handler = this.createDefaultContextScopeHandler();
        }
        context.put((Object)"C_S_H", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IStatus initializeScopeRetrieverHandlers(IContext context, CompoundScopeRetriever scope, ActivityParameters activityParams) {
        scope.addScopeRetriever(new RuleRelatedElementsScopeRetriever(), context);
        for (IHandler handler : ExtensionHelper.collectFromExtensions(context, "org.polarsys.capella.core.transition.handlers", "scopeRetriever", (String)context.get((Object)"TRANSPOSER_PURPOSE"), (String)context.get((Object)"TRANSPOSER_MAPPING"))) {
            if (!(handler instanceof IScopeRetriever)) continue;
            scope.addScopeRetriever((IScopeRetriever)handler, context);
        }
        return Status.OK_STATUS;
    }

    protected IStatus initializeScopeFilterHandlers(IContext context, CompoundScopeFilter scope, ActivityParameters activityParams) {
        for (IHandler handler : ExtensionHelper.collectFromExtensions(context, "org.polarsys.capella.core.transition.handlers", "scopeFilter", (String)context.get((Object)"TRANSPOSER_PURPOSE"), (String)context.get((Object)"TRANSPOSER_MAPPING"))) {
            if (!(handler instanceof IScopeFilter)) continue;
            scope.addScopeFilter((IScopeFilter)handler, context);
        }
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultContextScopeHandler() {
        return new DefaultContextScopeHandler();
    }

    protected IHandler createDefaultScopeHandler() {
        return new DefaultScopeHandler();
    }

    protected IStatus initializeTransformationHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("TrH", activityParams);
        if (handler == null) {
            handler = this.createDefaultTransformationHandler();
        }
        context.put((Object)"TrH", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultTransformationHandler() {
        return new DefaultTransformationHandler();
    }

    protected IStatus initializeSessionHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("_S_H", activityParams);
        if (handler == null) {
            handler = this.createDefaultSessionHandler();
        }
        context.put((Object)"_S_H", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultSessionHandler() {
        return new DefaultSessionHandler();
    }
}

