/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer.current;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.business.registry.GenericPurposeRegistry;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.mappings.purposes.NonExistingPurposeException;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.possibilities.MappingPossibilityResolutionException;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.rules.ComputePremisesException;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.rules.RuleExecutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IDomainHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;
import org.polarsys.kitalpha.transposer.rules.handler.rules.runtime.RuntimePurpose;

public class GenericRulesHandler
implements IRulesHandler {
    private IContext _context = null;
    private RuntimePurpose _runtimePurpose = null;
    private Map _knownObjects = new HashMap();
    private Set _knownObjectsWithoutApplicablePossibitity = new HashSet();

    public GenericRulesHandler(String purpose, String mappingId) throws NonExistingPurposeException {
        this.init(purpose, mappingId);
    }

    public void dispose() {
        if (this._context != null) {
            this._context.reset();
            this._context = null;
        }
        this._knownObjects.clear();
        this._knownObjectsWithoutApplicablePossibitity.clear();
        this._runtimePurpose = null;
    }

    public void setContext(IContext defaultContext) {
        this._context = defaultContext;
    }

    public List getPremises(Object object) throws ComputePremisesException {
        MappingPossibility applicablePossibility = null;
        try {
            applicablePossibility = this.getApplicablePossibility(object);
        }
        catch (MappingPossibilityResolutionException e) {
            throw new ComputePremisesException((Exception)((Object)e), object, this.getPurpose());
        }
        if (applicablePossibility != null) {
            IRule completeRule = applicablePossibility.getCompleteRule();
            return completeRule.getPremises(object);
        }
        return Collections.emptyList();
    }

    public void init(String purpose, String mappingId) throws NonExistingPurposeException {
        this._runtimePurpose = this.createRuntimePurpose(purpose, mappingId);
        if (this._runtimePurpose != null && this._runtimePurpose.getMapping() != null) {
            this._context = this._runtimePurpose.getMapping().getContext();
        }
    }

    protected RuntimePurpose createRuntimePurpose(String purpose, String mappingId) {
        return GenericPurposeRegistry.getInstance().getRegisteredPurpose(purpose, mappingId);
    }

    public IDomainHelper getDomainHelper() {
        return this._runtimePurpose.getMapping().getDomainHelper();
    }

    public String getPurpose() {
        return this._runtimePurpose.getName();
    }

    public boolean apply(Object object, boolean complete, IProgressMonitor monitor) throws RuleExecutionException {
        MappingPossibility applicablePossibility = null;
        try {
            applicablePossibility = this.getApplicablePossibility(object);
        }
        catch (MappingPossibilityResolutionException e) {
            throw new RuleExecutionException(e.getMessage(), (Throwable)e);
        }
        if (applicablePossibility == null) {
            return false;
        }
        if (applicablePossibility.getContext() != null) {
            applicablePossibility.updateContext(object, this._context);
        }
        if (monitor != null) {
            monitor.subTask(String.valueOf(applicablePossibility.getName()) + " (" + (complete ? "complete" : "incomplete") + ") " + object.getClass().getSimpleName());
        }
        applicablePossibility.applyRule(object, this._context, complete);
        return true;
    }

    public MappingPossibility getApplicablePossibility(Object object) throws MappingPossibilityResolutionException {
        MappingPossibility applicablePossibility = null;
        if (this._knownObjects.containsKey(object)) {
            return (MappingPossibility)this._knownObjects.get(object);
        }
        if (this._knownObjectsWithoutApplicablePossibitity.contains(object)) {
            return null;
        }
        applicablePossibility = this._runtimePurpose.getMapping().resolveApplicablePossibility(object, this._runtimePurpose.getMapping().getDomainHelper());
        if (applicablePossibility != null) {
            this._knownObjects.put(object, applicablePossibility);
        } else {
            this._knownObjectsWithoutApplicablePossibitity.add(object);
        }
        return applicablePossibility;
    }

    public void validatePurpose() {
        this._runtimePurpose.validate();
    }

    public IContext getContext() {
        return this._context;
    }
}

