/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.registry;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.ui.IEditorPart;
import org.polarsys.kitalpha.model.detachment.ui.Messages;
import org.polarsys.kitalpha.model.detachment.ui.page.AbstractDetachmentFormPage;
import org.polarsys.kitalpha.model.detachment.ui.registry.RegistryHelper;

public class ModelDetachmentPageRegistry {
    private static Logger LOGGER = Logger.getLogger(ModelDetachmentPageRegistry.class);
    private Set<AbstractDetachmentFormPage> registry = new HashSet<AbstractDetachmentFormPage>();
    public static final ModelDetachmentPageRegistry INSTANCE = new ModelDetachmentPageRegistry();

    private ModelDetachmentPageRegistry() {
    }

    public Set<AbstractDetachmentFormPage> initRegistry(IEditorPart editor) {
        this.dispose();
        IExtension[] extensions = RegistryHelper.getAllExtensionsFor("org.polarsys.kitalpha.model.detachment.ui.page");
        if (extensions != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (config.getName().equals("page")) {
                        String pageClass = config.getAttribute("class");
                        String id = config.getAttribute("id");
                        String title = config.getAttribute("title");
                        String finder_id = config.getAttribute("scrutinizeId");
                        String contributorID = config.getContributor().getName();
                        Object page = RegistryHelper.newFormPageInstanceWithParameters(contributorID, pageClass, editor, id, title);
                        AbstractDetachmentFormPage detachmentPage = (AbstractDetachmentFormPage)((Object)page);
                        detachmentPage.setFinderID(finder_id);
                        this.registry.add(detachmentPage);
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            LOGGER.warn((Object)Messages.MODEL_DETACHMENT_NO_EXTENSION_FOUND);
        }
        return this.registry;
    }

    public void dispose() {
        this.registry.clear();
    }

    public Set<AbstractDetachmentFormPage> getPageRegistry() {
        return this.registry;
    }
}

