/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Trace;

public class SourceElementContentProvider
implements ITreeContentProvider {
    protected CapellaElement currentElement;
    protected Map<TraceableElement, AbstractTrace> parentLinkMap = new HashMap<TraceableElement, AbstractTrace>();
    protected List<Class<? extends AbstractTrace>> traceType = new ArrayList<Class<? extends AbstractTrace>>();

    public Object[] getChildren(Object parentElement) {
        TraceableElement result;
        if (parentElement instanceof Class) {
            EList srcTraceList = this.currentElement.getIncomingTraces();
            ArrayList<AbstractTrace> result2 = new ArrayList<AbstractTrace>();
            for (AbstractTrace trace : srcTraceList) {
                if (!trace.getClass().equals(parentElement)) continue;
                result2.add(trace);
            }
            return result2.toArray();
        }
        if (parentElement instanceof Trace && (result = ((Trace)parentElement).getSourceElement()) != null) {
            this.parentLinkMap.put(result, (AbstractTrace)parentElement);
            return Collections.singleton(result).toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof AbstractNamedElement) {
            return this.parentLinkMap.get(element);
        }
        if (element instanceof Trace) {
            return ((Trace)element).getClass();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AbstractNamedElement) {
            return false;
        }
        return element instanceof Trace || element instanceof Class;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof CapellaElement) {
            this.currentElement = (CapellaElement)inputElement;
            EList srcTraceList = ((CapellaElement)inputElement).getIncomingTraces();
            this.traceType.clear();
            for (AbstractTrace currentTrace : srcTraceList) {
                if (this.traceType.contains(currentTrace.getClass())) continue;
                this.traceType.add(currentTrace.getClass());
            }
            return this.traceType.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.currentElement = (CapellaElement)newInput;
        this.parentLinkMap.clear();
    }

    public List<Class<? extends AbstractTrace>> getTraceType() {
        return this.traceType;
    }
}

