/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.capellacore.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.TypeHelper;

public class GeneralizableElementHelper {
    private static GeneralizableElementHelper instance;

    private GeneralizableElementHelper() {
    }

    public static GeneralizableElementHelper getInstance() {
        if (instance == null) {
            instance = new GeneralizableElementHelper();
        }
        return instance;
    }

    public Object doSwitch(GeneralizableElement element, EStructuralFeature feature) {
        List<Generalization> ret = null;
        if (feature.equals(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__SUB)) {
            ret = this.getSub(element);
        } else if (feature.equals(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__SUPER)) {
            ret = this.getSuper(element);
        } else if (feature.equals(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__SUB_GENERALIZATIONS)) {
            ret = this.getSubGeneralizations(element);
        } else if (feature.equals(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__SUPER_GENERALIZATIONS)) {
            ret = this.getSuperGeneralizations(element);
        }
        if (ret == null) {
            ret = TypeHelper.getInstance().doSwitch((Type)element, feature);
        }
        return ret;
    }

    protected List<GeneralizableElement> getSub(GeneralizableElement element) {
        ArrayList<GeneralizableElement> ret = new ArrayList<GeneralizableElement>();
        for (Generalization generalization : element.getSubGeneralizations()) {
            GeneralizableElement sub = generalization.getSub();
            if (sub == null) continue;
            ret.add(sub);
        }
        return ret;
    }

    protected List<GeneralizableElement> getSuper(GeneralizableElement element) {
        ArrayList<GeneralizableElement> ret = new ArrayList<GeneralizableElement>();
        for (Generalization generalization : element.getSuperGeneralizations()) {
            GeneralizableElement superr = generalization.getSuper();
            if (superr == null) continue;
            ret.add(superr);
        }
        return ret;
    }

    protected List<Generalization> getSubGeneralizations(GeneralizableElement element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CapellacorePackage.Literals.GENERALIZATION__SUPER);
    }

    protected List<Generalization> getSuperGeneralizations(GeneralizableElement element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CapellacorePackage.Literals.GENERALIZATION__SUB);
    }
}

