/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPathRealization;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolverElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPathInvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.fa.delegates.ComponentExchangeAllocatorHelper;

public class PhysicalPathHelper {
    private static PhysicalPathHelper instance;

    private PhysicalPathHelper() {
    }

    public static PhysicalPathHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalPathHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalPath element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CsPackage.Literals.PHYSICAL_PATH__FIRST_PHYSICAL_PATH_INVOLVEMENTS)) {
            ret = this.getFirstPhysicalPathInvolvements(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_PATH__REALIZED_PHYSICAL_PATHS)) {
            ret = this.getRealizedPhysicalPaths(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_PATH__REALIZING_PHYSICAL_PATHS)) {
            ret = this.getRealizingPhysicalPaths(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        if (ret == null) {
            ret = ComponentExchangeAllocatorHelper.getInstance().doSwitch((ComponentExchangeAllocator)element, feature);
        }
        if (ret == null) {
            ret = AbstractPathInvolvedElementHelper.getInstance().doSwitch((AbstractPathInvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = InvolverElementHelper.getInstance().doSwitch((InvolverElement)element, feature);
        }
        return ret;
    }

    protected List<PhysicalPathInvolvement> getFirstPhysicalPathInvolvements(PhysicalPath element) {
        ArrayList<PhysicalPathInvolvement> ret = new ArrayList<PhysicalPathInvolvement>();
        for (PhysicalPathInvolvement inv : element.getOwnedPhysicalPathInvolvements()) {
            if (inv.getInvolved() == null || !inv.getPreviousInvolvements().isEmpty()) continue;
            ret.add(inv);
        }
        return ret;
    }

    protected List<PhysicalPath> getRealizedPhysicalPaths(PhysicalPath element) {
        ArrayList<PhysicalPath> paths = new ArrayList<PhysicalPath>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement path;
            if (!(trace instanceof PhysicalPathRealization) || !((path = ((PhysicalPathRealization)trace).getTargetElement()) instanceof PhysicalPath)) continue;
            paths.add((PhysicalPath)path);
        }
        return paths;
    }

    protected List<PhysicalPath> getRealizingPhysicalPaths(PhysicalPath element) {
        ArrayList<PhysicalPath> paths = new ArrayList<PhysicalPath>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement path;
            if (!(trace instanceof PhysicalPathRealization) || !((path = ((PhysicalPathRealization)trace).getSourceElement()) instanceof PhysicalPath)) continue;
            paths.add((PhysicalPath)path);
        }
        return paths;
    }
}

