/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.copyformat;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.ui.copyformat.AbstractCapellaFormatDataKey;
import org.polarsys.capella.core.sirius.ui.copyformat.CapellaDecoratorFormatDataKey;

public class CapellaNodeFormatDataKey
extends CapellaDecoratorFormatDataKey {
    DSemanticDecorator decorator;

    public DSemanticDecorator getDecorator() {
        return this.decorator;
    }

    public CapellaNodeFormatDataKey(DSemanticDecorator inputDecorator, AbstractCapellaFormatDataKey key) {
        super(key);
        this.decorator = inputDecorator;
        EObject parent = this.getRelatedParent(this.decorator);
        if (this.decorator == null || this.decorator instanceof AbstractDNode) {
            this.addDecoration((EObject)DiagramPackage.Literals.ABSTRACT_DNODE);
        }
        if (this.decorator != null && this.decorator.getTarget() != null) {
            EObject semanticElement = this.decorator.getTarget();
            if (semanticElement instanceof ExchangeCategory) {
                if (parent != null) {
                    this.addDecoration(parent);
                }
                this.addDecoration(((DDiagramElement)this.decorator).getTarget());
                this.addDecoration(((DDiagramElement)this.decorator.eContainer()).getTarget());
                StyleDescription desc = ((DDiagramElement)this.decorator).getStyle().getDescription();
                if (desc instanceof SquareDescription) {
                    SquareDescription sd = (SquareDescription)desc;
                    ColorDescription color = sd.getColor();
                    super.addDecoration((EObject)color);
                }
            } else if (semanticElement instanceof FunctionalChainInvolvement && FunctionalChainServices.getFunctionalChainServices().isFCRegion(this.decorator.eContainer())) {
                FunctionalChain mainChain = (FunctionalChain)((DSemanticDiagram)((DDiagramElement)this.decorator).getParentDiagram()).getTarget();
                this.addDecoration((EObject)mainChain);
                List references = FunctionalChainServices.getFunctionalChainServices().computeFCReferenceHierarchy((EdgeTarget)this.decorator, mainChain);
                for (FunctionalChainReference ref : references) {
                    this.addDecoration((EObject)ref);
                }
            } else if (parent != null && !(parent instanceof DDiagram)) {
                this.addDecoration(parent);
            }
        }
    }

    protected EObject getRelatedParent(DSemanticDecorator inputDecorator) {
        if (inputDecorator == null) {
            return null;
        }
        return inputDecorator.eContainer();
    }

    @Override
    protected void addDecoration(EObject object) {
        if (object != null) {
            if (object instanceof DSemanticDecorator) {
                DSemanticDecorator sourceDecorator = (DSemanticDecorator)object;
                if (sourceDecorator.getTarget() != null) {
                    this.addDecoration(sourceDecorator.getTarget());
                }
            } else {
                super.addDecoration(object);
            }
        } else {
            super.addDecoration(object);
        }
    }
}

