/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.UpdateCategoriesController;

public class UpdateCECategoriesController
extends UpdateCategoriesController {
    @Override
    public void updateCategories(List<EObject> selectedElements, List<EObject> categoriesToAdd, List<EObject> categoriesToRemove) {
        for (EObject e : selectedElements) {
            if (!(e instanceof ComponentExchange)) continue;
            for (EObject removed : categoriesToRemove) {
                ((ComponentExchangeCategory)removed).getExchanges().remove((Object)e);
            }
            for (EObject added : categoriesToAdd) {
                ((ComponentExchangeCategory)added).getExchanges().add((Object)((ComponentExchange)e));
            }
        }
        if (!selectedElements.isEmpty() && selectedElements.get(0) instanceof CommunicationMean) {
            this.logResults(Messages.UpdateCMCategories_add_msg, categoriesToAdd);
            this.logResults(Messages.UpdateCMCategories_remove_msg, categoriesToRemove);
        } else {
            this.logResults(Messages.UpdateCECategories_add_msg, categoriesToAdd);
            this.logResults(Messages.UpdateCECategories_remove_msg, categoriesToRemove);
        }
    }

    @Override
    public List<EObject> getAvailableCategories(List<EObject> element) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject fe : element) {
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(fe.eClass(), (EStructuralFeature)FaPackage.Literals.COMPONENT_EXCHANGE__CATEGORIES);
            if (query == null) continue;
            result.addAll(query.getAvailableElements(fe));
        }
        return result;
    }

    @Override
    public List<EObject> getCommonCategories(List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (selection.isEmpty()) {
            return result;
        }
        EObject first = selection.get(0);
        if (first instanceof ComponentExchange) {
            result.addAll((Collection<EObject>)((ComponentExchange)first).getCategories());
        }
        for (EObject eObject : selection) {
            if (!(eObject instanceof ComponentExchange)) continue;
            result.retainAll((Collection<?>)((ComponentExchange)eObject).getCategories());
        }
        return result;
    }
}

