/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.validation.synchronizationmode;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.IAdditionalConstraint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.ValidationStatus;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.validation.Activator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.validation.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdiagram.SynchronizationMode;

public abstract class AbstractImportSynchronizationModeRule
implements IAdditionalConstraint {
    private SynchronizationMode translateToViewpointSynchronizationMode(boolean isCreatedElement, boolean isSynchronizationLock) throws IllegalStateException {
        if (!isCreatedElement && !isSynchronizationLock) {
            return SynchronizationMode.NOT_SYNCHRONIZED;
        }
        if (isCreatedElement && !isSynchronizationLock) {
            return SynchronizationMode.UNSYNCHRONIZABLE;
        }
        if (isCreatedElement && isSynchronizationLock) {
            return SynchronizationMode.SYNCHRONIZED;
        }
        throw new IllegalStateException("Synchronization Mode values are not allowed");
    }

    protected String getMessage(String label, Object object) {
        SynchronizationMode importedSyncMode = this.translateToViewpointSynchronizationMode(this.isCreateElement(object), this.isSynchronizedLock(object));
        SynchronizationMode currentSyncMode = this.getSynchronizationMode(object);
        List<SynchronizationMode> compatibleMode = this.getCompatibleModesWith(importedSyncMode);
        return Messages.bind((String)Messages.Validation_Diagram_Synchrinization, (Object[])new Object[]{label, importedSyncMode, currentSyncMode, compatibleMode});
    }

    protected abstract SynchronizationMode getSynchronizationMode(Object var1);

    protected abstract boolean isCreateElement(Object var1);

    protected abstract boolean isSynchronizedLock(Object var1);

    public final ValidationStatus validationRules(Object data) {
        try {
            boolean createElement = this.isCreateElement(data);
            boolean synchronizedLock = this.isSynchronizedLock(data);
            SynchronizationMode syncMode = this.translateToViewpointSynchronizationMode(createElement, synchronizedLock);
            SynchronizationMode syncModeDiagramSpec = this.getSynchronizationMode(data);
            switch (syncModeDiagramSpec) {
                case SYNCHRONIZED: 
                case UNSYNCHRONIZABLE: {
                    return this.isCompatibleSyncMode(syncMode);
                }
                case NOT_SYNCHRONIZED: {
                    return this.isCompatibleNotSyncMode(syncMode);
                }
                case DEFAULT: {
                    return ValidationStatus.Ok;
                }
            }
        }
        catch (IllegalStateException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.validation", e.getMessage(), (Throwable)e));
            return ValidationStatus.Error;
        }
        return ValidationStatus.Warning;
    }

    private ValidationStatus isCompatibleNotSyncMode(SynchronizationMode syncMode) {
        if (syncMode.equals((Object)SynchronizationMode.NOT_SYNCHRONIZED)) {
            return ValidationStatus.Ok;
        }
        return ValidationStatus.Error;
    }

    private ValidationStatus isCompatibleSyncMode(SynchronizationMode syncMode) {
        switch (syncMode) {
            case SYNCHRONIZED: 
            case UNSYNCHRONIZABLE: {
                return ValidationStatus.Ok;
            }
            case NOT_SYNCHRONIZED: {
                return ValidationStatus.Error;
            }
        }
        throw new IllegalStateException("Cannot infer the right synchronization mode");
    }

    private List<SynchronizationMode> getCompatibleModesWith(SynchronizationMode mode) {
        ArrayList<SynchronizationMode> result = new ArrayList<SynchronizationMode>();
        switch (mode) {
            case NOT_SYNCHRONIZED: {
                result.clear();
                result.add(SynchronizationMode.NOT_SYNCHRONIZED);
                return result;
            }
        }
        result.clear();
        result.add(SynchronizationMode.SYNCHRONIZED);
        result.add(SynchronizationMode.UNSYNCHRONIZABLE);
        return result;
    }
}

