/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.platform.sirius.clipboard.Messages;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.AbstractResultCommand;
import org.polarsys.capella.core.platform.sirius.clipboard.util.CapellaDiagramClipboard;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;

public class CapellaDiagramCopyCommand
extends AbstractResultCommand {
    private List<? extends View> _toCopyGmf;

    public CapellaDiagramCopyCommand(List<? extends EObject> toCopy_p) {
        assert (toCopy_p != null);
        this._toCopyGmf = MiscUtil.filter(toCopy_p, View.class);
    }

    public void run() {
        List<View> toCopy = this.minimizeByPartTypeContainment(this._toCopyGmf);
        CapellaDiagramClipboard.getInstance().copy(toCopy);
    }

    private List<View> minimizeByPartTypeContainment(List<? extends View> views_p) {
        ArrayList<View> result = new ArrayList<View>(views_p);
        List<Part> parts = MiscUtil.filter(LayerUtil.toSemanticLevel(views_p), Part.class);
        ArrayList<AbstractType> partTypes = new ArrayList<AbstractType>();
        for (Part part : parts) {
            partTypes.add(part.getAbstractType());
        }
        for (View view : views_p) {
            EObject semanticElement = LayerUtil.toSemanticLevel(view);
            if (!EcoreUtil.isAncestor(partTypes, (EObject)semanticElement)) continue;
            result.remove(view);
        }
        return result;
    }

    public String getName() {
        return Messages.CapellaDiagramCopyCommand_Name;
    }
}

