/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.linkedtext.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.polarsys.capella.common.linkedtext.ui.DefaultLinkedTextContentProvider;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextCompletionProcessor;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;

public class EmbeddedLinkedTextEditorConfiguration
extends SourceViewerConfiguration {
    public static final String HYPERLINK_COLOR = "org.polarsys.capella.common.linkedtext.ui.linkedTextHyperlinkColor";
    public static final String FONT = "org.polarsys.capella.common.linkedtext.ui.font";

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        LinkedTextCompletionProcessor completionProcessor = new LinkedTextCompletionProcessor(this.getCompletionProcessorContentProvider());
        ca.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
        ca.setProposalPopupOrientation(10);
        ca.setContextInformationPopupOrientation(20);
        ca.addCompletionListener((ICompletionListener)completionProcessor);
        return ca;
    }

    protected IStructuredContentProvider getCompletionProcessorContentProvider() {
        return new DefaultLinkedTextContentProvider((Predicate<EObject>)Predicates.alwaysTrue());
    }

    public IPresentationReconciler getPresentationReconciler(final ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        final IThemeManager manager = PlatformUI.getWorkbench().getThemeManager();
        ITheme theme = manager.getCurrentTheme();
        final AtomicReference<Color> hyperlinkColor = new AtomicReference<Color>(theme.getColorRegistry().get(HYPERLINK_COLOR));
        final AtomicReference<Font> font = new AtomicReference<Font>(theme.getFontRegistry().get(FONT));
        theme.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(EmbeddedLinkedTextEditorConfiguration.HYPERLINK_COLOR)) {
                    hyperlinkColor.set(manager.getCurrentTheme().getColorRegistry().get(EmbeddedLinkedTextEditorConfiguration.HYPERLINK_COLOR));
                    sourceViewer.invalidateTextPresentation();
                } else if (event.getProperty().equals(EmbeddedLinkedTextEditorConfiguration.FONT)) {
                    font.set(manager.getCurrentTheme().getFontRegistry().get(EmbeddedLinkedTextEditorConfiguration.FONT));
                    sourceViewer.invalidateTextPresentation();
                }
            }
        });
        reconciler.setDamager(new IPresentationDamager(){

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
                return new Region(event.getOffset(), event.getText().length());
            }

            public void setDocument(IDocument document) {
            }
        }, "__dftl_partition_content_type");
        reconciler.setRepairer(new IPresentationRepairer(){
            private TextAttribute defaultTextAttribute = new TextAttribute(null);
            private IDocument doc;

            public void setDocument(IDocument document) {
                this.doc = document;
            }

            public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
                StyleRange normal = new StyleRange(0, this.doc.getLength(), this.defaultTextAttribute.getForeground(), this.defaultTextAttribute.getBackground());
                normal.font = (Font)font.get();
                presentation.mergeStyleRange(normal);
                for (LinkedTextHyperlink hl : ((LinkedTextDocument)this.doc).getHyperlinks()) {
                    StyleRange range = new StyleRange(hl.getOffset(), hl.getLength(), (Color)hyperlinkColor.get(), this.defaultTextAttribute.getBackground());
                    if (hl.getTarget() == null) {
                        range.strikeout = true;
                        range.foreground = Display.getCurrent().getSystemColor(3);
                    }
                    presentation.mergeStyleRange(range);
                }
            }
        }, "__dftl_partition_content_type");
        return reconciler;
    }
}

