/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.cs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.PortExt;

public class GetAvailable_PhysicalPort_AllocatedComponentPorts
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        return this.getAvailableElements(capellaElement);
    }

    public List<Object> getAvailableElements(CapellaElement element) {
        if (element instanceof PhysicalPort) {
            return List.copyOf(this.getAvailablePorts((PhysicalPort)element));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public List<EObject> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        if (!(element instanceof PhysicalPort)) {
            return Collections.emptyList();
        }
        HashSet<Port> currentElements = new HashSet<Port>();
        PhysicalPort elt = (PhysicalPort)element;
        for (AbstractTrace trace : elt.getOutgoingTraces()) {
            void portAllocation;
            ComponentPortAllocation componentPortAllocation;
            AbstractTrace abstractTrace = trace;
            if (!(abstractTrace instanceof ComponentPortAllocation) || (componentPortAllocation = (ComponentPortAllocation)abstractTrace) != (ComponentPortAllocation)abstractTrace || portAllocation.getAllocatedPort() == null) continue;
            currentElements.add(portAllocation.getAllocatedPort());
        }
        currentElements.remove(elt);
        return List.copyOf(currentElements);
    }

    private Set<Port> getAvailablePorts(PhysicalPort sourcePort) {
        List<PhysicalPort> targetPorts = this.getTheOthersPhysicalPort(sourcePort);
        List<Component> sourceDeployedComponents = this.getDeployedElements(sourcePort);
        List targetDeployedComponents = targetPorts.stream().flatMap(pp -> this.getDeployedElements((PhysicalPort)pp).stream()).toList();
        HashSet availableElements = new HashSet();
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(sourceDeployedComponents, targetDeployedComponents));
        availableElements.addAll(PhysicalComponentExt.findConnectionsBetweenPhysicalComponentes(targetDeployedComponents, sourceDeployedComponents));
        HashSet<Port> list = new HashSet<Port>();
        for (ComponentExchange ce : availableElements) {
            Component source = ComponentExchangeExt.getSourceComponent((ComponentExchange)ce);
            if (sourceDeployedComponents.contains(source)) {
                list.add(ce.getSourcePort());
                continue;
            }
            list.add(ce.getTargetPort());
        }
        return list;
    }

    private List<PhysicalPort> getTheOthersPhysicalPort(PhysicalPort port) {
        PhysicalPort pp = port;
        ArrayList<PhysicalPort> result = new ArrayList<PhysicalPort>();
        for (PhysicalLink pLink : port.getInvolvedLinks()) {
            for (AbstractPhysicalLinkEnd linkEnd : pLink.getLinkEnds()) {
                if (linkEnd instanceof PhysicalPort) {
                    pp = (PhysicalPort)linkEnd;
                } else if (linkEnd instanceof PhysicalLinkEnd) {
                    pp = ((PhysicalLinkEnd)linkEnd).getPort();
                }
                if (pp.equals(port)) continue;
                result.add(pp);
            }
        }
        return result;
    }

    private List<Component> getDeployedElements(PhysicalPort port) {
        Component container = PortExt.getRelatedComponent((PhysicalPort)port);
        if (container == null) {
            return Collections.emptyList();
        }
        Collection sourceComponents = ComponentExt.getAllSubUsedComponents((Component)container);
        sourceComponents.add(container);
        ArrayList<Component> deployedComponents = new ArrayList<Component>();
        for (Component component : sourceComponents) {
            if (component instanceof SystemComponent) {
                deployedComponents.add(component);
                continue;
            }
            if (component instanceof LogicalComponent) {
                deployedComponents.addAll(LogicalComponentExt.getAllSubComponents((LogicalComponent)((LogicalComponent)component)));
                continue;
            }
            if (!(component instanceof PhysicalComponent)) continue;
            deployedComponents.add(component);
            for (AbstractTypedElement abstractTypedElement : component.getAbstractTypedElements()) {
                if (!(abstractTypedElement instanceof Part var9_9)) continue;
                Stream.concat(PartExt.getSubUsedParts((Part)typedPart).stream(), PartExt.getAllDeployableElements((Part)typedPart).stream()).filter(Part.class::isInstance).map(p -> PartExt.getComponentOfPart((Part)((Part)p))).filter(Objects::nonNull).forEachOrdered(deployedComponents::add);
            }
        }
        return deployedComponents;
    }
}

