/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.business.abstractqueries.helpers.CapellaElementsHelperForBusinessQueries;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.PropertyExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetAvailable_UnionProperty_Type
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<EObject> returnValue = new ArrayList<EObject>();
        BlockArchitecture currentBlockArchitecture = DataPkgExt.getRootBlockArchitecture((ModelElement)element);
        SystemEngineering systemEngineering = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)element);
        OperationalAnalysis operationalAnalysis = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        returnValue.addAll(this.getDataFromLevel((BlockArchitecture)operationalAnalysis, element));
        if (!(currentBlockArchitecture instanceof OperationalAnalysis)) {
            SystemAnalysis systemAnalysis = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            returnValue.addAll(this.getDataFromLevel((BlockArchitecture)systemAnalysis, element));
            if (!(currentBlockArchitecture instanceof SystemAnalysis)) {
                LogicalArchitecture logicalArchitecture = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                returnValue.addAll(this.getDataFromLevel((BlockArchitecture)logicalArchitecture, element));
                if (!(currentBlockArchitecture instanceof LogicalArchitecture)) {
                    PhysicalArchitecture physicalArchitecture = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                    returnValue.addAll(this.getDataFromLevel((BlockArchitecture)physicalArchitecture, element));
                    if (!(currentBlockArchitecture instanceof PhysicalArchitecture)) {
                        EPBSArchitecture epbsArchitecture = SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)systemEngineering);
                        returnValue.addAll(this.getDataFromLevel((BlockArchitecture)epbsArchitecture, element));
                    }
                }
            }
        }
        returnValue.addAll(this.getUnlevelizedData(element));
        returnValue.addAll(this.getDataFromComponentHierarchy(element));
        returnValue.addAll(this.getDataFromRealizedComponentsHierarchy(element));
        returnValue.addAll(this.getTypesFromComponentHierarchy(element));
        returnValue = this.filterUnNamedElements(returnValue);
        return returnValue;
    }

    public List<EObject> getDataFromLevel(BlockArchitecture blockArchitecture, CapellaElement capellaElement) {
        DataPkg dataPkg;
        if (blockArchitecture != null && (dataPkg = blockArchitecture.getOwnedDataPkg()) != null) {
            return this.getDataFromLevel(dataPkg, capellaElement);
        }
        return Collections.emptyList();
    }

    public List<CapellaElement> getUnlevelizedData(CapellaElement capellaElement) {
        return Collections.emptyList();
    }

    protected List<EObject> getDataFromComponentHierarchy(CapellaElement element) {
        ArrayList<EObject> allDatas = new ArrayList<EObject>();
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            DataPkg dataPkg = cpnt.getOwnedDataPkg();
            if (dataPkg == null) continue;
            allDatas.addAll(this.getDataFromLevel(dataPkg, element));
        }
        return allDatas;
    }

    protected List<EObject> getDataFromRealizedComponentsHierarchy(CapellaElement element) {
        Component currentCpnt;
        ArrayList<EObject> allDatas = new ArrayList<EObject>();
        Component component = currentCpnt = element instanceof Component ? (Component)element : null;
        if (currentCpnt == null) {
            currentCpnt = (Component)EcoreUtil2.getFirstContainer((EObject)element, (EClass)CsPackage.Literals.COMPONENT);
        }
        if (currentCpnt != null) {
            for (Component allocatedCpnt : currentCpnt.getRealizedComponents()) {
                List componentHierarchy = CapellaElementExt.getComponentHierarchy((CapellaElement)allocatedCpnt);
                componentHierarchy.add(allocatedCpnt);
                for (Component cpnt : componentHierarchy) {
                    DataPkg dataPkg = cpnt.getOwnedDataPkg();
                    if (dataPkg == null) continue;
                    for (EObject data : this.getDataFromLevel(dataPkg, element)) {
                        if (allDatas.contains(data)) continue;
                        allDatas.add(data);
                    }
                }
            }
        }
        return allDatas;
    }

    protected List<EObject> getTypesFromComponentHierarchy(CapellaElement element) {
        List<EObject> allDatas = new ArrayList<EObject>();
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            DataPkg dataPkg = cpnt.getOwnedDataPkg();
            if (dataPkg == null) continue;
            allDatas.addAll(DataPkgExt.getAllTypesFromDataPkg((DataPkg)dataPkg));
        }
        allDatas = this.removeNonPrimitiveClasses(allDatas);
        allDatas = this.removeNonPrimitiveCollections(allDatas);
        return allDatas;
    }

    protected List<EObject> filterUnNamedElements(List<EObject> list) {
        ArrayList<EObject> result = new ArrayList<EObject>(1);
        for (EObject capellaElement : list) {
            String name;
            if (!(capellaElement instanceof AbstractNamedElement) || (name = ((AbstractNamedElement)capellaElement).getName()) == null || "".equals(name)) continue;
            result.add(capellaElement);
        }
        return result;
    }

    protected List<EObject> removePrimitiveClasses(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveClasses(elements, true);
    }

    protected List<EObject> removePrimitiveCollections(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveCollections(elements, true);
    }

    protected List<EObject> removeNonPrimitiveClasses(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveClasses(elements, false);
    }

    protected List<EObject> removeNonPrimitiveCollections(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveCollections(elements, false);
    }

    protected List<EObject> removePrimitiveOrNonPrimitiveClasses(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Class) {
                Class currentClass = (Class)element;
                if ((removePrimitive || !currentClass.isIsPrimitive()) && (!removePrimitive || currentClass.isIsPrimitive())) continue;
                returnValue.add((EObject)currentClass);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }

    protected List<EObject> removePrimitiveOrNonPrimitiveCollections(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Collection) {
                Collection currentCollection = (Collection)element;
                if ((removePrimitive || !currentCollection.isIsPrimitive()) && (!removePrimitive || currentCollection.isIsPrimitive())) continue;
                returnValue.add((EObject)currentCollection);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }

    public List<EObject> getDataFromLevel(DataPkg dataPkg, CapellaElement capellaElement) {
        Association association = GetAvailable_UnionProperty_Type.getRegardingAssociation(capellaElement);
        List<EObject> returnValue = CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, InformationPackage.Literals.CLASS, null);
        returnValue.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, InformationPackage.Literals.COLLECTION, null));
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        eClasses.add(InformationPackage.Literals.CLASS);
        eClasses.add(InformationPackage.Literals.COLLECTION);
        returnValue.addAll(this.getElementsFromDataPkgContainedInComponent(capellaElement, eClasses, capellaElement));
        eClasses.clear();
        if (association != null) {
            returnValue = this.addAssociationsSpecificElements(returnValue, association, capellaElement, dataPkg);
            returnValue = this.removePrimitiveClasses(returnValue);
            returnValue = this.removePrimitiveCollections(returnValue);
        } else {
            List<EObject> dataTypes = CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, DatatypePackage.Literals.DATA_TYPE, null);
            returnValue.addAll(dataTypes);
            eClasses.add(DatatypePackage.Literals.DATA_TYPE);
            returnValue.addAll(this.getElementsFromDataPkgContainedInComponent(capellaElement, eClasses, capellaElement));
            returnValue = this.removeNonPrimitiveClasses(returnValue);
            returnValue = this.removeNonPrimitiveCollections(returnValue);
        }
        return returnValue;
    }

    protected static Association getRegardingAssociation(CapellaElement elem) {
        return PropertyExt.getRegardingAssociation((CapellaElement)elem);
    }

    private java.util.Collection<? extends EObject> getElementsFromDataPkgContainedInComponent(CapellaElement capellaElement, List<EClass> classes, CapellaElement capellaElement2) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>(1);
        List componentHierarchy = CapellaElementExt.getComponentHierarchy((CapellaElement)capellaElement);
        if (!componentHierarchy.isEmpty()) {
            for (Component component : componentHierarchy) {
                List allDataPkgs = DataPkgExt.getAllDataPkgs((EObject)component);
                for (DataPkg dataPkg : allDataPkgs) {
                    for (EClass eClass : classes) {
                        returnValue.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, eClass, null));
                    }
                }
            }
        }
        return returnValue;
    }

    protected List<EObject> addAssociationsSpecificElements(List<EObject> list, Association association, CapellaElement elem, DataPkg dataPkg) {
        Property prop;
        AggregationKind aggregationKind;
        if (association != null && elem instanceof Property && (aggregationKind = (prop = (Property)elem).getAggregationKind()) == AggregationKind.ASSOCIATION) {
            list.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, CommunicationPackage.Literals.SIGNAL, null));
            list.addAll(CapellaElementsHelperForBusinessQueries.getCapellaElementsInstancesOf(dataPkg, CommunicationPackage.Literals.EXCEPTION, null));
        }
        return list;
    }
}

