/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.model.helpers.PropertyExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public abstract class AbstractPropertyTypeRule
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Property) {
            Property property = (Property)eObj;
            EObject eContainer = property.eContainer();
            if (this.isParentPrimitiveCheckApplied(eContainer)) {
                return ctx.createSuccessStatus();
            }
            if (PropertyExt.getRegardingAssociation((CapellaElement)property) == null) {
                Collection collection;
                AbstractType abstractType = property.getAbstractType();
                if (abstractType instanceof Class) {
                    Class cls = (Class)abstractType;
                    if (!cls.isIsPrimitive()) {
                        return ctx.createFailureStatus(new Object[]{property.getName(), cls.getName(), cls.eClass().getName()});
                    }
                } else if (abstractType instanceof Collection && !(collection = (Collection)abstractType).isIsPrimitive()) {
                    return ctx.createFailureStatus(new Object[]{property.getName(), collection.getName(), collection.eClass().getName()});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    public abstract boolean isParentPrimitiveCheckApplied(EObject var1);
}

