/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.handlers.traceability;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ReconciliationTraceabilityHandler
extends LevelBasedTraceabilityHandler {
    public ReconciliationTraceabilityHandler(String identifier) {
        super(identifier);
    }

    protected boolean isLevelElement(EObject object, IContext context) {
        return true;
    }

    protected void initializeMapping(EObject source, EObject target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        if (source instanceof SystemEngineering && target instanceof SystemEngineering) {
            this.initializeSystemEngineering((SystemEngineering)source, (SystemEngineering)target, context, map);
        }
        if (source instanceof BlockArchitecture && target instanceof BlockArchitecture) {
            this.initializeBlockArchitecture((BlockArchitecture)source, (BlockArchitecture)target, context, map);
        }
        if (source instanceof Component && target instanceof Component) {
            this.initializeComponent((Component)source, (Component)target, context, map);
        }
        if (source instanceof ComponentPkg && target instanceof ComponentPkg) {
            this.initializeComponentPkg((ComponentPkg)source, (ComponentPkg)target, context, map);
        }
        if (source instanceof FunctionPkg && target instanceof FunctionPkg) {
            this.initializeFunctionPkg((FunctionPkg)source, (FunctionPkg)target, context, map);
        }
        if (source instanceof DataPkg && target instanceof DataPkg) {
            this.initializeDataPkg((DataPkg)source, (DataPkg)target, context, map);
        }
        if (source instanceof TraceableElement && target instanceof TraceableElement) {
            this.initializeTraceableElement((TraceableElement)source, (TraceableElement)target, context, map);
        }
    }

    protected void initializeDataPkg(DataPkg source, DataPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        BlockArchitecture sourceBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
        BlockArchitecture targetBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        if (sourceBlockArchitecture != null && targetBlockArchitecture != null) {
            DataPkg sourceDataPkg = BlockArchitectureExt.getDataPkg((BlockArchitecture)sourceBlockArchitecture);
            DataPkg targetDataPkg = BlockArchitectureExt.getDataPkg((BlockArchitecture)targetBlockArchitecture);
            if (source == sourceDataPkg && target == targetDataPkg) {
                this.addMapping((MappingTraceability)map, (EObject)sourceDataPkg, (EObject)targetDataPkg, context);
                Optional<DataPkg> sourcePredefinedTypes = sourceDataPkg.getOwnedDataPkgs().stream().filter(pkg -> NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name.equals(pkg.getName())).findFirst();
                Optional<DataPkg> targetPredefinedTypes = targetDataPkg.getOwnedDataPkgs().stream().filter(pkg -> NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name.equals(pkg.getName())).findFirst();
                if (sourcePredefinedTypes.isPresent() && targetPredefinedTypes.isPresent()) {
                    this.initializeDataType((EObject)sourcePredefinedTypes.get(), (EObject)targetPredefinedTypes.get(), context, map);
                }
            }
        }
    }

    protected void initializeDataType(EObject source, EObject target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        if (source.eClass().equals(target.eClass())) {
            this.addMapping((MappingTraceability)map, source, target, context);
            for (EReference reference : source.eClass().getEAllReferences()) {
                Object targetValue;
                Object sourceValue;
                if (!reference.isContainment()) continue;
                if (!reference.isMany()) {
                    sourceValue = source.eGet((EStructuralFeature)reference);
                    targetValue = target.eGet((EStructuralFeature)reference);
                    if (sourceValue == null || targetValue == null || !(sourceValue instanceof EObject) || !(targetValue instanceof EObject) || !((EObject)sourceValue).eClass().equals(((EObject)targetValue).eClass())) continue;
                    this.initializeDataType((EObject)sourceValue, (EObject)targetValue, context, map);
                    continue;
                }
                if (!reference.isMany()) continue;
                sourceValue = source.eGet((EStructuralFeature)reference);
                targetValue = target.eGet((EStructuralFeature)reference);
                if (sourceValue == null || targetValue == null || !(sourceValue instanceof EList) || !(targetValue instanceof EList)) continue;
                EList sourceList = (EList)sourceValue;
                EList targetList = (EList)targetValue;
                int i = 0;
                while (i < sourceList.size()) {
                    sourceValue = sourceList.get(i);
                    if (sourceValue != null && sourceValue instanceof EObject) {
                        EObject sourceObject = (EObject)sourceValue;
                        int j = 0;
                        while (j < targetList.size()) {
                            Object targetObject = targetList.get(j);
                            if (targetObject != null && targetObject instanceof EObject && ((EObject)targetObject).eClass().equals(sourceObject.eClass())) {
                                if (targetObject instanceof AbstractNamedElement && sourceObject instanceof AbstractNamedElement) {
                                    AbstractNamedElement sourceNamed = (AbstractNamedElement)sourceObject;
                                    AbstractNamedElement targetNamed = (AbstractNamedElement)targetObject;
                                    if (sourceNamed.getName() == null && targetNamed.getName() == null || sourceNamed.getName() != null && sourceNamed.getName().equals(targetNamed.getName())) {
                                        this.initializeDataType(sourceObject, (EObject)targetObject, context, map);
                                        break;
                                    }
                                } else {
                                    this.initializeDataType(sourceObject, (EObject)targetObject, context, map);
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void initializeTraceableElement(TraceableElement source, TraceableElement target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance((IContext)context);
        for (AbstractTrace sourceTrace : source.getIncomingTraces()) {
            for (AbstractTrace targetTrace : target.getIncomingTraces()) {
                if (sourceTrace.eClass() != targetTrace.eClass() || !(sourceTrace instanceof Allocation) || !(targetTrace instanceof Allocation) || sourceTrace.getSourceElement() == null || targetTrace.getSourceElement() == null || sourceTrace.getTargetElement() == null || targetTrace.getTargetElement() == null || !handler.retrieveTracedElements((EObject)sourceTrace.getSourceElement(), context).contains(targetTrace.getSourceElement()) || !handler.retrieveTracedElements((EObject)sourceTrace.getTargetElement(), context).contains(targetTrace.getTargetElement())) continue;
                this.addMapping((MappingTraceability)map, (EObject)sourceTrace, (EObject)targetTrace, context);
            }
        }
        for (AbstractTrace sourceTrace : source.getOutgoingTraces()) {
            for (AbstractTrace targetTrace : target.getOutgoingTraces()) {
                if (sourceTrace.eClass() != targetTrace.eClass() || !(sourceTrace instanceof Allocation) || !(targetTrace instanceof Allocation) || sourceTrace.getSourceElement() == null || targetTrace.getSourceElement() == null || sourceTrace.getTargetElement() == null || targetTrace.getTargetElement() == null || !handler.retrieveTracedElements((EObject)sourceTrace.getSourceElement(), context).contains(targetTrace.getSourceElement()) || !handler.retrieveTracedElements((EObject)sourceTrace.getTargetElement(), context).contains(targetTrace.getTargetElement())) continue;
                this.addMapping((MappingTraceability)map, (EObject)sourceTrace, (EObject)targetTrace, context);
            }
        }
    }

    protected void initializeFunctionPkg(FunctionPkg source, FunctionPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
    }

    protected void initializeComponent(Component source, Component target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance((IContext)context);
        for (Part sourcePartition : source.getContainedParts()) {
            if (sourcePartition.getType() == null) continue;
            Part targetPart = null;
            for (Part targetPartition : target.getContainedParts()) {
                if (targetPartition.getType() == null || !handler.retrieveTracedElements((EObject)sourcePartition.getType(), context).contains(targetPartition.getType())) continue;
                targetPart = targetPart != null ? null : targetPartition;
            }
            if (targetPart == null) continue;
            this.addMapping((MappingTraceability)map, (EObject)sourcePartition, (EObject)targetPart, context);
        }
        if (source.getRepresentingParts().size() == 1 && target.getRepresentingParts().size() == 1) {
            Part sourcePartition;
            sourcePartition = (Part)source.getRepresentingParts().get(0);
            Part targetPartition = (Part)target.getRepresentingParts().get(0);
            this.addMapping((MappingTraceability)map, (EObject)sourcePartition, (EObject)targetPartition, context);
        }
    }

    protected void initializeComponentPkg(ComponentPkg source, ComponentPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance((IContext)context);
        block0: for (Part sourcePart : source.getOwnedParts()) {
            if (sourcePart.getType() == null) continue;
            for (Part targetPart : target.getOwnedParts()) {
                if (targetPart.getType() == null || !handler.retrieveTracedElements((EObject)sourcePart.getType(), context).contains(targetPart.getType())) continue;
                this.addMapping((MappingTraceability)map, (EObject)sourcePart, (EObject)targetPart, context);
                continue block0;
            }
        }
    }

    protected void initializeSystemEngineering(SystemEngineering source, SystemEngineering target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        for (ModellingArchitecture archi : source.getOwnedArchitectures()) {
            for (ModellingArchitecture archi2 : target.getOwnedArchitectures()) {
                if (archi2.eClass() != archi.eClass()) continue;
                this.addMapping((MappingTraceability)map, (EObject)archi, (EObject)archi2, context);
            }
        }
    }

    protected void initializeBlockArchitecture(BlockArchitecture source, BlockArchitecture target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)target, (boolean)false), context);
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getRootFunction((BlockArchitecture)target, (boolean)false), context);
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getDataPkg((BlockArchitecture)target, (boolean)false), context);
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getActorPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getActorPkg((BlockArchitecture)target, (boolean)false), context);
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getContext((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getContext((BlockArchitecture)target, (boolean)false), context);
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)target, (boolean)false), context);
        this.addMapping((MappingTraceability)map, (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)source, (boolean)false), (EObject)BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)target, (boolean)false), context);
    }
}

