/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.eval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.sirius.query.legacy.gen.template.TemplateElement;
import org.eclipse.sirius.query.legacy.gen.template.eval.StringComparator;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;

public class TextTemplateElementMapping {
    protected Map pos2TemplateElement = new TreeMap(new InversePosComparator());
    protected Map template2Positions = new HashMap();
    protected Map template2CommentPositions = new HashMap();
    protected Map pos2LinkTemplateElement = new TreeMap(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Int2 pos0 = (Int2)arg0;
            Int2 pos1 = (Int2)arg1;
            if (pos0.b() < pos1.b()) {
                return 1;
            }
            if (pos0.b() > pos1.b()) {
                return -1;
            }
            if (pos0.e() < pos1.e()) {
                return -1;
            }
            if (pos0.e() > pos1.e()) {
                return 1;
            }
            return 0;
        }
    });
    protected List[] highlightedPos = new List[2];
    public static final int HIGHLIGHTED_DEFAULT = -1;
    public static final int HIGHLIGHTED_STATIC_TEXT = 0;
    public static final int HIGHLIGHTED_COMMENT = 1;
    protected TemplateElement template;
    protected int shift;
    protected boolean commit = false;
    protected TemplateElement linkTemplateElement = null;
    private Map index2TemplateElement = new HashMap();
    private Map index2LinkTemplateElement = new HashMap();

    public TextTemplateElementMapping(TemplateElement template, boolean freeze) {
        this.template = template;
        int i = 0;
        while (i < this.highlightedPos.length) {
            if (this.highlightedPos[i] == null) {
                this.highlightedPos[i] = new ArrayList();
            }
            ++i;
        }
        if (freeze) {
            this.commit = true;
        } else {
            this.reset();
        }
    }

    protected void reset() {
        if (!this.commit) {
            this.shift = 0;
            this.pos2TemplateElement.clear();
            this.index2TemplateElement.clear();
            this.template2Positions.clear();
            this.template2CommentPositions.clear();
            this.pos2LinkTemplateElement.clear();
            this.index2LinkTemplateElement.clear();
            int i = 0;
            while (i < this.highlightedPos.length) {
                if (this.highlightedPos[i] != null) {
                    this.highlightedPos[i].clear();
                } else {
                    this.highlightedPos[i] = new ArrayList();
                }
                ++i;
            }
        }
    }

    public void from(TextTemplateElementMapping other) {
        if (!this.commit && other != null) {
            TemplateElement template;
            int e;
            int b;
            for (Map.Entry entry : other.pos2TemplateElement.entrySet()) {
                b = this.shift + ((Int2)entry.getKey()).b();
                e = this.shift + ((Int2)entry.getKey()).e();
                template = (TemplateElement)entry.getValue();
                this.addMapping(template, b, e);
            }
            for (Map.Entry entry : other.template2CommentPositions.entrySet()) {
                List value = (List)entry.getValue();
                for (Int2 pos : value) {
                    int b2 = this.shift + pos.b();
                    int e2 = this.shift + pos.e();
                    TemplateElement template2 = (TemplateElement)entry.getKey();
                    this.addCommentMapping(template2, b2, e2);
                }
            }
            for (Map.Entry entry : other.pos2LinkTemplateElement.entrySet()) {
                b = this.shift + ((Int2)entry.getKey()).b();
                e = this.shift + ((Int2)entry.getKey()).e();
                template = (TemplateElement)entry.getValue();
                this.pos2LinkTemplateElement.put(new Int2(b, e), template);
            }
            int i = 0;
            while (i < other.highlightedPos.length) {
                for (Int2 pos : other.highlightedPos[i]) {
                    this.highlightedPos[i].add(new Int2(this.shift + pos.b(), this.shift + pos.e()));
                }
                ++i;
            }
            this.shift += other.shift;
        }
    }

    public void shift(int size) {
        this.shift(size, -1);
    }

    public void shift(int size, int highlightedType) {
        if (!this.commit) {
            Int2 pos;
            if (this.linkTemplateElement != null) {
                pos = new Int2(this.shift, this.shift + size);
                this.pos2LinkTemplateElement.put(pos, this.linkTemplateElement);
            }
            if (highlightedType == 0) {
                pos = new Int2(this.shift, this.shift + size);
                this.highlightedPos[0].add(pos);
            } else if (highlightedType == 1) {
                pos = new Int2(this.shift, this.shift + size);
                this.highlightedPos[1].add(pos);
                this.addCommentMapping(this.template, pos.b(), pos.e());
            }
            this.shift += size;
        }
    }

    protected void addMapping(TemplateElement template, int begin, int end) {
        if (begin > -1 && end > -1) {
            ArrayList templatePositions;
            Int2 newPos = new Int2(begin, end);
            if (!this.pos2TemplateElement.containsKey(newPos)) {
                this.pos2TemplateElement.put(newPos, template);
            }
            if ((templatePositions = (ArrayList)this.template2Positions.get(template)) == null) {
                templatePositions = new ArrayList();
                this.template2Positions.put(template, templatePositions);
            }
            this.add(templatePositions, begin, end);
        }
    }

    protected void addCommentMapping(TemplateElement template, int begin, int end) {
        if (begin > -1 && end > -1) {
            ArrayList commentPositions = (ArrayList)this.template2CommentPositions.get(template);
            if (commentPositions == null) {
                commentPositions = new ArrayList();
                this.template2CommentPositions.put(template, commentPositions);
            }
            this.add(commentPositions, begin, end);
        }
    }

    private void add(List positions, int begin, int end) {
        boolean insert = false;
        Iterator it = positions.iterator();
        while (!insert && it.hasNext()) {
            Int2 pos = (Int2)it.next();
            if (begin <= pos.e() && begin >= pos.b()) {
                if (end > pos.e()) {
                    positions.remove(pos);
                    this.add(positions, pos.b(), end);
                }
                insert = true;
                continue;
            }
            if (end >= pos.b() && end <= pos.e()) {
                if (begin < pos.b()) {
                    positions.remove(pos);
                    this.add(positions, begin, pos.e());
                }
                insert = true;
                continue;
            }
            if (begin >= pos.b() || end <= pos.e()) continue;
            positions.remove(pos);
            this.add(positions, begin, end);
            insert = true;
        }
        if (!insert) {
            positions.add(new Int2(begin, end));
        }
    }

    public void linkBegin(TemplateElement linkTemplateElement) {
        this.linkTemplateElement = linkTemplateElement;
    }

    public void linkEnd() {
        this.linkTemplateElement = null;
    }

    protected void commit() {
        if (!this.commit) {
            this.commit = true;
            this.addMapping(this.template, 0, this.shift);
        }
    }

    public TemplateElement index2TemplateElement(int index) {
        TemplateElement template = (TemplateElement)this.index2TemplateElement.get(new Integer(index));
        if (template == null) {
            if (!this.commit) {
                this.commit();
            }
            Iterator it = this.pos2TemplateElement.entrySet().iterator();
            while (template == null && it.hasNext()) {
                int e;
                Map.Entry entry = it.next();
                int b = ((Int2)entry.getKey()).b();
                if (index < b || index >= (e = ((Int2)entry.getKey()).e())) continue;
                template = (TemplateElement)entry.getValue();
            }
            this.index2TemplateElement.put(new Integer(index), template);
        }
        return template;
    }

    @Deprecated
    public Map position2uriSerializableMap() {
        TreeMap<Int2, String> result = new TreeMap<Int2, String>(new InversePosComparator());
        if (!this.commit) {
            this.commit();
        }
        for (Map.Entry entry : this.pos2TemplateElement.entrySet()) {
            Int2 pos = (Int2)entry.getKey();
            TemplateElement template = (TemplateElement)entry.getValue();
            String uriFragment = template.getURIFragment();
            result.put(pos, uriFragment);
        }
        return result;
    }

    public Int2[] template2Positions(TemplateElement template) {
        List positions;
        if (template == null) {
            return new Int2[0];
        }
        if (!this.commit) {
            this.commit();
        }
        if ((positions = (List)this.template2Positions.get(template)) != null) {
            return positions.toArray(new Int2[positions.size()]);
        }
        return new Int2[0];
    }

    @Deprecated
    public Map uri2positionsSerializableMap() {
        TreeMap<String, Int2[]> result = new TreeMap<String, Int2[]>(new StringComparator());
        if (!this.commit) {
            this.commit();
        }
        for (Map.Entry entry : this.template2Positions.entrySet()) {
            TemplateElement template = (TemplateElement)entry.getKey();
            String uriFragment = template.getURIFragment();
            TreeSet positions = new TreeSet(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Int2 pos0 = (Int2)arg0;
                    Int2 pos1 = (Int2)arg1;
                    if (pos0.b() < pos1.b()) {
                        return -1;
                    }
                    if (pos0.b() > pos1.b()) {
                        return 1;
                    }
                    if (pos0.e() < pos1.e()) {
                        return 1;
                    }
                    if (pos0.e() > pos1.e()) {
                        return -1;
                    }
                    return 0;
                }
            });
            positions.addAll((List)entry.getValue());
            result.put(uriFragment, positions.toArray(new Int2[positions.size()]));
        }
        return result;
    }

    public Int2 template2CommentPositionIn(TemplateElement template, Int2 limits) {
        List positions;
        if (template == null) {
            return Int2.NOT_FOUND;
        }
        if (!this.commit) {
            this.commit();
        }
        if ((positions = (List)this.template2CommentPositions.get(template)) != null) {
            for (Int2 pos : positions) {
                if (pos.b() < limits.b() || pos.e() > limits.e()) continue;
                return pos;
            }
        }
        return Int2.NOT_FOUND;
    }

    public TemplateElement index2LinkTemplateElement(int index) {
        TemplateElement template = (TemplateElement)this.index2LinkTemplateElement.get(new Integer(index));
        if (template == null) {
            if (!this.commit) {
                this.commit();
            }
            Iterator it = this.pos2LinkTemplateElement.entrySet().iterator();
            while (template == null && it.hasNext()) {
                int e;
                Map.Entry entry = it.next();
                int b = ((Int2)entry.getKey()).b();
                if (index < b || index >= (e = ((Int2)entry.getKey()).e())) continue;
                template = (TemplateElement)entry.getValue();
            }
            this.index2LinkTemplateElement.put(new Integer(index), template);
        }
        return template;
    }

    public Int2[] getHighlightedPos(int highlightedType) {
        if (highlightedType == 0) {
            return this.highlightedPos[0].toArray(new Int2[0]);
        }
        if (highlightedType == 1) {
            return this.highlightedPos[1].toArray(new Int2[0]);
        }
        return new Int2[0];
    }

    public void range(Int2 range) {
        if (!this.commit) {
            Int2 pos;
            Iterator positions;
            List value;
            Int2 copy;
            Int2 pos2;
            Map.Entry entry2;
            this.shift = range.e() - range.b();
            Iterator it = this.pos2TemplateElement.entrySet().iterator();
            while (it.hasNext()) {
                entry2 = it.next();
                pos2 = (Int2)entry2.getKey();
                copy = new Int2(pos2.b(), pos2.e());
                copy.range(range);
                if (copy.b() == -1 || !copy.equals(pos2) && this.pos2TemplateElement.containsKey(copy)) {
                    it.remove();
                    continue;
                }
                pos2.range(range);
            }
            for (Map.Entry entry2 : this.template2Positions.entrySet()) {
                value = (List)entry2.getValue();
                positions = value.iterator();
                while (positions.hasNext()) {
                    pos = (Int2)positions.next();
                    pos.range(range);
                    if (pos.b() != -1) continue;
                    positions.remove();
                }
            }
            for (Map.Entry entry2 : this.template2CommentPositions.entrySet()) {
                value = (List)entry2.getValue();
                positions = value.iterator();
                while (positions.hasNext()) {
                    pos = (Int2)positions.next();
                    pos.range(range);
                    if (pos.b() != -1) continue;
                    positions.remove();
                }
            }
            it = this.pos2LinkTemplateElement.entrySet().iterator();
            while (it.hasNext()) {
                entry2 = it.next();
                pos2 = (Int2)entry2.getKey();
                copy = new Int2(pos2.b(), pos2.e());
                copy.range(range);
                if (copy.b() == -1 || !copy.equals(pos2) && this.pos2LinkTemplateElement.containsKey(copy)) {
                    it.remove();
                    continue;
                }
                pos2.range(range);
            }
            List[] listArray = this.highlightedPos;
            int n = this.highlightedPos.length;
            int n2 = 0;
            while (n2 < n) {
                List highlightedPo = listArray[n2];
                it = highlightedPo.iterator();
                while (it.hasNext()) {
                    Int2 pos3 = (Int2)((Object)it.next());
                    pos3.range(range);
                    if (pos3.b() != -1) continue;
                    it.remove();
                }
                ++n2;
            }
        }
    }

    public void indent(Int2[] lines) {
        if (!this.commit) {
            List value;
            this.shift += lines.length;
            for (Map.Entry entry : this.pos2TemplateElement.entrySet()) {
                ((Int2)entry.getKey()).indent(lines);
            }
            for (Map.Entry entry : this.template2Positions.entrySet()) {
                value = (List)entry.getValue();
                for (Int2 pos : value) {
                    pos.indent(lines);
                }
            }
            for (Map.Entry entry : this.template2CommentPositions.entrySet()) {
                value = (List)entry.getValue();
                for (Int2 pos : value) {
                    pos.indent(lines);
                }
            }
            for (Map.Entry entry : this.pos2LinkTemplateElement.entrySet()) {
                ((Int2)entry.getKey()).indent(lines);
            }
            List[] listArray = this.highlightedPos;
            int n = this.highlightedPos.length;
            int n2 = 0;
            while (n2 < n) {
                List highlightedPo = listArray[n2];
                for (Int2 pos : highlightedPo) {
                    pos.indent(lines);
                }
                ++n2;
            }
        }
    }

    private static class InversePosComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private InversePosComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Int2 pos0 = (Int2)arg0;
            Int2 pos1 = (Int2)arg1;
            if (pos0.b() < pos1.b()) {
                return 1;
            }
            if (pos0.b() > pos1.b()) {
                return -1;
            }
            if (pos0.e() < pos1.e()) {
                return -1;
            }
            if (pos0.e() > pos1.e()) {
                return 1;
            }
            return 0;
        }
    }
}

