/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.Template;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.eval.merge.MergeTools;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateFeatureStatement;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateForStatement;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateCallSetExpression
extends TemplateExpression {
    protected List calls = new ArrayList();

    public TemplateCallSetExpression(IScript script) {
        super(script);
    }

    public void addCall(TemplateCallExpression call) {
        if (this.calls.size() > 0) {
            TemplateCallExpression last = (TemplateCallExpression)this.calls.get(this.calls.size() - 1);
            last.setNextCall(call);
        }
        this.calls.add(call);
        call.setParent(this);
    }

    public TemplateCallExpression getFirst() {
        if (this.calls.size() > 0) {
            return (TemplateCallExpression)this.calls.get(0);
        }
        return null;
    }

    public Iterator iterator() {
        return this.calls.iterator();
    }

    public boolean isPredefined() {
        boolean predefined = false;
        if (this.calls.size() > 0) {
            TemplateCallExpression call = (TemplateCallExpression)this.calls.get(0);
            if (call.link.equals(TemplateConstants.LINK_NAME_INDEX) && call.arguments.size() == 0 && "".equals(call.getPrefix())) {
                return true;
            }
            if (call.link.equals(TemplateConstants.LINK_NAME_ARGS) && call.arguments.size() == 1 && "".equals(call.getPrefix())) {
                predefined = true;
            } else if (call.link.equals(TemplateConstants.USER_BEGIN_NAME) && call.arguments.size() == 0) {
                if (this.parent instanceof TemplateFeatureStatement) {
                    predefined = true;
                }
            } else if (call.link.equals(TemplateConstants.USER_END_NAME) && call.arguments.size() == 0 && this.parent instanceof TemplateFeatureStatement) {
                predefined = true;
            }
        }
        return predefined;
    }

    @Override
    public ENode evaluate(ENode current, IScript script, LaunchManager mode) throws ENodeException, FactoryException {
        script.contextPush(IScript.CURRENT_NODE, current);
        try {
            Iterator calls = this.calls.iterator();
            if (calls.hasNext()) {
                ENode first;
                boolean predefined;
                TemplateCallExpression call;
                block27: {
                    call = (TemplateCallExpression)calls.next();
                    predefined = false;
                    if (call.link.equals(TemplateConstants.LINK_NAME_INDEX) && call.arguments.size() == 0 && "".equals(call.getPrefix())) {
                        Integer index = (Integer)script.contextPeek(IScript.WHILE_INDEX);
                        if (index == null) {
                            index = new Integer(0);
                        }
                        current = new ENode(index, current);
                        predefined = true;
                    } else {
                        if (call.link.equals(TemplateConstants.LINK_NAME_ARGS) && call.arguments.size() == 1 && "".equals(call.getPrefix())) {
                            ENode[] templateArgs = (ENode[])script.contextPeek(IScript.TEMPLATE_ARGS);
                            if (templateArgs == null) {
                                templateArgs = new ENode[]{};
                            }
                            ENode index = ((TemplateExpression)call.arguments.get(0)).evaluate(current, script, mode);
                            try {
                                int i = index.getInt();
                                if (i < templateArgs.length) {
                                    current = templateArgs[i];
                                    predefined = true;
                                    break block27;
                                }
                                throw new ENodeException(AcceleoGenMessages.getString("TemplateCallSetExpression.UnresolvedArgument", new Object[]{Integer.toString(i)}), call.getPos(), script, current, true);
                            }
                            catch (ENodeCastException eNodeCastException) {
                                throw new ENodeException(AcceleoGenMessages.getString("TemplateCallSetExpression.InvalidArgument"), call.getPos(), script, current, true);
                            }
                        }
                        if (call.link.equals(TemplateConstants.USER_BEGIN_NAME) && call.arguments.size() == 0) {
                            current = new ENode(MergeTools.DEFAULT_USER_BEGIN, current);
                            predefined = true;
                        } else if (call.link.equals(TemplateConstants.USER_END_NAME) && call.arguments.size() == 0) {
                            current = new ENode(MergeTools.DEFAULT_USER_END, current);
                            predefined = true;
                        }
                    }
                }
                if (predefined) {
                    if (calls.hasNext()) {
                        call = (TemplateCallExpression)calls.next();
                    } else {
                        ENode eNode = current;
                        return eNode;
                    }
                }
                current = first = call.evaluate(current, script, mode);
                while (calls.hasNext()) {
                    call = (TemplateCallExpression)calls.next();
                    current = call.evaluate(current, script, mode);
                }
                if (!predefined) {
                    if (current.isString() && first.isEObject() && !first.isContainment()) {
                        try {
                            ENode node = new ENode("", first);
                            if (node.getTextModelMapping() != null) {
                                node.getTextModelMapping().linkBegin(first.getEObject());
                            }
                            node.append(current);
                            if (node.getTextModelMapping() != null) {
                                node.getTextModelMapping().linkEnd();
                            }
                            current = node;
                        }
                        catch (ENodeCastException eNodeCastException) {}
                    }
                    if (first.isOptional()) {
                        current.setOptional(true);
                    }
                }
            }
            ENode eNode = current;
            return eNode;
        }
        finally {
            script.contextPop(IScript.CURRENT_NODE);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("");
        Iterator calls = this.calls.iterator();
        while (calls.hasNext()) {
            TemplateCallExpression call = (TemplateCallExpression)calls.next();
            buffer.append(call.toString());
            if (!calls.hasNext()) continue;
            buffer.append(TemplateConstants.CALL_SEP);
        }
        return buffer.toString();
    }

    public static TemplateExpression fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Int2 trim = TextSearch.getDefaultSearch().trim(buffer, limits.b(), limits.e());
        if (trim.b() == -1) {
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingElement"), script, limits);
        }
        limits = trim;
        Int2[] positions = TextSearch.getDefaultSearch().splitPositionsIn(buffer, limits.b(), limits.e(), new String[]{TemplateConstants.CALL_SEP}, false, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
        TemplateCallSetExpression expression = new TemplateCallSetExpression(script);
        expression.setPos(limits);
        Int2[] int2Array = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Int2 pos = int2Array[n2];
            expression.addCall((TemplateCallExpression)TemplateCallExpression.fromString(buffer, pos, script));
            ++n2;
        }
        return expression;
    }

    public Object getRootResolver(Object defaultRoot, IScript gen) {
        TemplateElement parent = this.getParent();
        TemplateElement current = this;
        boolean inForBlock = false;
        while (parent != null) {
            if (parent instanceof Template && parent.getParent() instanceof TemplateForStatement) {
                inForBlock = true;
            } else if (parent instanceof TemplateForStatement) {
                TemplateCallSetExpression firstCallSet;
                TemplateExpression forCondition;
                List testElements;
                if (inForBlock && (testElements = (forCondition = ((TemplateForStatement)parent).getCondition()).getAllElements(TemplateCallSetExpression.class)).size() > 0 && (firstCallSet = (TemplateCallSetExpression)testElements.get(0)) != null) {
                    Object resolvedType = firstCallSet.getRootResolver(defaultRoot, gen);
                    Iterator calls = firstCallSet.iterator();
                    while (resolvedType != null && calls.hasNext()) {
                        TemplateCallExpression call = (TemplateCallExpression)calls.next();
                        resolvedType = gen.resolveType(resolvedType, call, 0);
                    }
                    return resolvedType;
                }
            } else if (parent instanceof TemplateCallExpression && ((TemplateCallExpression)parent).filter == current && parent.getParent() instanceof TemplateCallSetExpression) {
                TemplateCallSetExpression callSet = (TemplateCallSetExpression)parent.getParent();
                Object resolvedType = callSet.getRootResolver(defaultRoot, gen);
                Iterator calls = callSet.iterator();
                while (resolvedType != null && calls.hasNext()) {
                    TemplateCallExpression call = (TemplateCallExpression)calls.next();
                    resolvedType = gen.resolveType(resolvedType, call, 0);
                    if (call == parent) break;
                }
                return resolvedType;
            }
            current = parent;
            parent = parent.getParent();
        }
        return defaultRoot;
    }
}

