/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.statements;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateNodeElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalFailure;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;

public class TemplateFeatureStatement
extends TemplateNodeElement {
    protected TemplateExpression expression;

    public TemplateFeatureStatement(TemplateExpression expression, IScript script) {
        super(script);
        this.expression = expression;
        this.expression.setParent(this);
    }

    public TemplateExpression getExpression() {
        return this.expression;
    }

    @Override
    public ENode evaluate(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        try {
            ENode result = this.evaluateSub(object, mode);
            return result;
        }
        catch (ENodeException e) {
            ENode result = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
            result.log().addError(new EvalFailure(e.getMessage()));
            return result;
        }
    }

    private ENode evaluateSub(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        ENode current = new ENode(object, this, mode.isSynchronize());
        this.script.contextPush(IScript.CURRENT_NODE, current);
        try {
            ENode node = this.expression.evaluate(current, this.script, mode);
            if (node.isNull() && !node.isOptional()) {
                if (node.log().hasError()) {
                    ENode eNode = node;
                    return eNode;
                }
                throw new ENodeException(AcceleoGenMessages.getString("ENodeError.EmptyEvaluation"), this.expression.getPos(), this.expression.getScript(), object, false);
            }
            ENode eNode = node;
            return eNode;
        }
        finally {
            this.script.contextPop(IScript.CURRENT_NODE);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(TemplateConstants.FEATURE_BEGIN) + this.expression.toString() + TemplateConstants.FEATURE_END;
    }

    @Override
    public String getOutlineText() {
        return this.expression.toString();
    }

    public static TemplateNodeElement fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        TemplateExpression expression = TemplateExpression.fromString(buffer, new Int2(limits.b(), limits.e()), script);
        TemplateFeatureStatement element = new TemplateFeatureStatement(expression, script);
        element.setPos(limits);
        return element;
    }
}

